/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.ui.IDataPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.FunctionFactory;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OperationPanel
extends JPanel
implements IDataPanel,
ItemListener,
ListSelectionListener {
    private ResultSchemaPanel m_SchemaPanel;
    private JComboBox m_Operation;
    private List<ChangeListener> m_Listeners = new ArrayList<ChangeListener>();

    public OperationPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.add((Component)this.m_SchemaPanel, "Center");
        this.m_SchemaPanel.addListSelectionListener(this);
        jPanel.add((Component)new JLabel(Messages.getString("OperationPanel.OPERATION")), "West");
        this.m_Operation = new JComboBox(this.getOperations());
        this.m_Operation.setRenderer(new FunctionFactory.FunctionLCR());
        this.m_Operation.setSelectedIndex(0);
        this.m_Operation.addItemListener(this);
        jPanel.add((Component)this.m_Operation, "Center");
        this.add((Component)jPanel, "South");
    }

    @Override
    public void setControlSource(ControlSource controlSource) {
        this.m_SchemaPanel.setSelectedName(controlSource.getField());
        this.m_Operation.setSelectedItem(controlSource.getOperation());
        if (this.m_Operation.getSelectedIndex() < 0) {
            this.m_Operation.setSelectedIndex(0);
        }
    }

    protected ComboBoxModel getOperations() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        Function[] functionArray = iFunctionFactory.getAll();
        for (int i = 0; i < functionArray.length; ++i) {
            defaultComboBoxModel.addElement(functionArray[i].getName());
        }
        return defaultComboBoxModel;
    }

    @Override
    public ControlSource getControlSource() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Operation");
        controlSource.setField(this.m_SchemaPanel.getSelectedName());
        controlSource.setOperation((String)this.m_Operation.getSelectedItem());
        controlSource.setRange("All");
        return controlSource;
    }

    @Override
    public void addDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.m_SchemaPanel.addDoubleClickListener(doubleClickListener);
    }

    @Override
    public void update(IWizard iWizard) {
        DataSchema dataSchema = ((IChartData)iWizard).getSchema();
        if (dataSchema != null) {
            HashSet<String> hashSet = new HashSet<String>();
            String string = this.m_SchemaPanel.getSelectedName();
            this.m_SchemaPanel.setSchema(dataSchema, hashSet);
            this.m_SchemaPanel.setSelectedName(string);
        }
        boolean bl = !iWizard.isReadOnly();
        this.m_SchemaPanel.setEnabled(bl);
        this.m_Operation.setEnabled(bl);
    }

    @Override
    public boolean isOk() {
        return this.m_SchemaPanel.getSelection() >= 0;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.fireChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_Listeners.remove(changeListener);
    }

    private void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.m_Listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

