/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.chart2.model.PieUi;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.LegendPaintTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.PieTab;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class PiePage
extends TypeSpecificPage
implements IFinishPage,
IChartProvider {
    public static final String NAME = "Pie";
    private DataTab m_KeyTab;
    private DataTab m_ValueTab;
    private PieTab m_PieTab;
    TitleTab m_TitleTab;
    LegendTab m_LegendTab;
    private LegendPaintTab m_LegendPaintTab;

    public PiePage() {
        super(NAME);
        this.setTitle(Messages.getString("PiePage.TITLE"));
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
                PieType pieType = (PieType)iChart.getChartType();
                this.m_KeyTab.setControlSource(pieType.getKeySource());
                this.m_ValueTab.setControlSource(this.getControlSource(pieType.getValueSource()));
                this.m_TitleTab.setTitle(pieType.getTitle());
                this.m_LegendTab.setLegend(pieType.getLegend());
                this.m_LegendPaintTab.setLegend(pieType.getLegend());
                this.m_Initialized = true;
            }
        }
        super.setVisible(bl);
    }

    protected void updatePanels() {
        this.m_KeyTab.updatePanels(this.m_Wizard);
        this.m_ValueTab.updatePanels(this.m_Wizard);
        this.m_PieTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
        this.m_LegendPaintTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void buildTabs() {
        this.m_KeyTab = new DataTab(Messages.getString("PiePage.KEY"), 5, false){

            @Override
            public void exited() {
                IChart iChart = PiePage.this.getChart();
                PieType pieType = (PieType)iChart.getChartType();
                pieType.setKeySource(this.getControlSource());
            }
        };
        this.addTab(this.m_KeyTab);
        this.m_ValueTab = new DataTab(Messages.getString("PiePage.VALUE"), 135, true){

            @Override
            public void exited() {
                IChart iChart = PiePage.this.getChart();
                PieType pieType = (PieType)iChart.getChartType();
                ControlSourceList controlSourceList = new ControlSourceList();
                controlSourceList.addControlSource(this.getControlSource());
                pieType.setValueSource(controlSourceList);
            }
        };
        this.addTab(this.m_ValueTab);
        this.m_PieTab = new PieTab(this);
        this.addTab(this.m_PieTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = PiePage.this.getChart().getChartType();
                chartType.setTitle(PiePage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = PiePage.this.getChart().getChartType();
                Legend legend = PiePage.this.m_LegendTab.getLegend();
                chartType.setLegend(legend);
                PiePage.this.m_LegendPaintTab.updateLegend(legend);
            }
        };
        this.addTab(this.m_LegendTab);
        this.m_LegendPaintTab = new LegendPaintTab(){

            @Override
            public void exited() {
                ChartType chartType = PiePage.this.getChart().getChartType();
                PiePage.this.m_LegendPaintTab.updateLegend(chartType.getLegend());
            }
        };
        this.addTab(this.m_LegendPaintTab);
        super.buildTabs();
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        PieType pieType = (PieType)iChart.getChartType();
        pieType.setKeySource(this.m_KeyTab.getControlSource());
        pieType.setValueSource(this.setControlSource(this.m_ValueTab.getControlSource()));
        pieType.setTitle(this.m_TitleTab.getTitle());
        Legend legend = this.m_LegendTab.getLegend();
        pieType.setLegend(legend);
        this.m_LegendPaintTab.updateLegend(legend);
        super.applyChanges(iChart);
    }

    private ControlSource initData() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        return controlSource;
    }

    private ControlSourceList initValueData() {
        return this.setControlSource(this.initData());
    }

    private ControlSource getControlSource(ControlSourceList controlSourceList) {
        if (controlSourceList != null && controlSourceList.getControlSourceCount() > 0) {
            return controlSourceList.getControlSource(0);
        }
        return new ControlSource();
    }

    private ControlSourceList setControlSource(ControlSource controlSource) {
        ControlSourceList controlSourceList = new ControlSourceList();
        controlSourceList.addControlSource(controlSource);
        return controlSourceList;
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof PieType)) {
            PieType pieType = new PieType();
            pieType.setKeySource(this.initData());
            pieType.setValueSource(this.initValueData());
            PieUi pieUi = new PieUi();
            pieUi.init();
            pieType.setPieUi(pieUi);
            iChart.setChartType((ChartType)pieType);
        }
    }
}

