/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.chart2.model.PieUi;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.ValuePanel;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.NonNegativeIntegerDocument;
import com.elixirtech.ui.NonNegativeNumberDocument;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

class PieTab
extends TabComponent
implements ActionListener {
    private static final String FORMAT_LABEL = "format-label";
    private static final String FORMAT = "format";
    private static final String SLICE_LABEL = "slice-label";
    private static final String SLICE = "slice";
    private static final String PERCENT_LABEL = "percent-label";
    private static final String PERCENT = "percent";
    private static final String INVERT = "invert";
    private static final String BG_BUTTON = "bg-button";
    private static final String LBG_BUTTON = "lbg-button";
    private static final String KEY = "key";
    public static final String V_VALUE = "v-value";
    private IChartProvider m_Page;
    private ValuePanel m_ValuePanel;
    private ColorPanel m_Background;
    private ColorPanel m_LabelBackground;
    private JCheckBox m_RetainKeyOrder;
    private JTextField m_Slice;
    private JTextField m_Percent;
    private JTextField m_LabelFormat;
    private Font m_Font;

    public PieTab(IChartProvider iChartProvider) {
        this.m_Page = iChartProvider;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.m_Background = new ColorPanel(Messages.getString("PieTab.PLOT_BACKGROUND"));
        this.m_LabelBackground = new ColorPanel(Messages.getString("PieTab.LABEL_BACKGROUND"));
        this.m_RetainKeyOrder = new JCheckBox(Messages.getString("PieTab.RETAIN_KEY_ORDER"));
        this.m_ValuePanel = new ValuePanel(Messages.getString("PieTab.LABEL"));
        this.m_LabelFormat = new JTextField(10);
        this.m_Slice = new JTextField(10);
        this.m_Slice.setDocument(new NonNegativeIntegerDocument());
        this.m_Percent = new JTextField(10);
        this.m_Percent.setDocument(new NonNegativeNumberDocument());
        this.m_Background.build(this, "bg");
        this.m_ValuePanel.build(this, "v");
        this.m_LabelBackground.build(this, "lbg");
        this.add(FORMAT, this.m_LabelFormat);
        this.add(FORMAT_LABEL, new JLabel(Messages.getString("PieTab.LABEL_FORMAT")));
        this.add(KEY, this.m_RetainKeyOrder);
        this.add(SLICE_LABEL, new JLabel(Messages.getString("PieTab.EXPLODE_SLICE")));
        this.add(SLICE, this.m_Slice);
        this.add(PERCENT_LABEL, new JLabel(Messages.getString("PieTab.EXPLODE_PERCENT")));
        this.add(PERCENT, this.m_Percent);
        archLayout.stickTop(BG_BUTTON);
        archLayout.putRight(BG_BUTTON, "bg-name,lbg-name,format-label ,slice-label,percent-label", 10);
        archLayout.alignBelow(LBG_BUTTON, BG_BUTTON, 5);
        archLayout.alignBelow(FORMAT, LBG_BUTTON, 5);
        archLayout.stickLeft(FORMAT_LABEL);
        archLayout.vCenter(FORMAT_LABEL, FORMAT);
        archLayout.alignBelow(V_VALUE, FORMAT, 5);
        archLayout.alignBelow(SLICE, V_VALUE, 5);
        archLayout.stickLeft(SLICE_LABEL);
        archLayout.vCenter(SLICE_LABEL, SLICE);
        archLayout.alignBelow(PERCENT, SLICE);
        archLayout.stickLeft(PERCENT_LABEL);
        archLayout.vCenter(PERCENT_LABEL, PERCENT);
        archLayout.stickLeft(INVERT);
        archLayout.putBelow(INVERT, PERCENT);
        archLayout.stickLeft(KEY);
        archLayout.putBelow(KEY, INVERT);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void entered() {
        IChart iChart = this.m_Page.getChart();
        PieType pieType = (PieType)iChart.getChartType();
        PieUi pieUi = pieType.getPieUi();
        this.m_Font = pieUi.getFont();
        this.m_Background.setColor(pieUi.getPlotBackground());
        this.m_LabelBackground.setColor(pieUi.getValueBackground());
        this.m_RetainKeyOrder.setSelected(pieType.isRetainKeyOrder());
        this.m_Slice.setText(String.valueOf(pieUi.getExplodeSector()));
        this.m_Percent.setText(String.valueOf(pieUi.getExplodePercentage()));
        this.m_ValuePanel.setInverted(pieType.isInverted());
        this.m_ValuePanel.setValue(pieUi.getValue());
        this.m_LabelFormat.setText(pieUi.getLabelFormat());
    }

    @Override
    public void exited() {
        IChart iChart = this.m_Page.getChart();
        PieType pieType = (PieType)iChart.getChartType();
        PieUi pieUi = pieType.getPieUi();
        pieUi.setPlotBackground(this.m_Background.getColor());
        pieUi.setValueBackground(this.m_LabelBackground.getColor());
        if (this.m_Font != null) {
            pieUi.setFont(this.m_Font);
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = pieUi.getExplodeSector();
        try {
            int n2 = Integer.parseInt(this.m_Slice.getText());
            pieUi.setExplodeSector(n2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
            String string = this.m_Slice.getText();
            stringBuilder.append(Messages.getString("PieTab.ERROR1"));
            if (StringUtil.notEmpty(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(". \n");
            this.m_Slice.setText(Integer.toString(n));
        }
        float f = pieUi.getExplodePercentage();
        try {
            float f2 = Float.parseFloat(this.m_Percent.getText());
            pieUi.setExplodePercentage(f2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
            String string = this.m_Percent.getText();
            stringBuilder.append(Messages.getString("PieTab.ERROR2"));
            if (StringUtil.notEmpty(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(". \n");
            this.m_Percent.setText(Float.toString(f));
        }
        if (bl) {
            ElixirJ.error(stringBuilder.toString());
        }
        pieType.setInverted(this.m_ValuePanel.isInverted());
        pieType.setRetainKeyOrder(this.m_RetainKeyOrder.isSelected());
        pieUi.setValue(this.m_ValuePanel.getValue());
        pieUi.setLabelFormat(this.m_LabelFormat.getText());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_LabelBackground.setEnabled(bl);
        this.m_RetainKeyOrder.setEnabled(bl);
        this.m_LabelFormat.setEnabled(bl);
        this.m_ValuePanel.setEnabled(bl);
        IChart iChart = this.m_Page.getChart();
        String string = iChart.getType();
        boolean bl2 = "Pie".equals(string) && bl;
        this.m_Slice.setEnabled(bl2);
        this.m_Percent.setEnabled(bl2);
        this.m_ValuePanel.invertEnabled(bl && string.startsWith("Pie-Multi"));
    }

    @Override
    public String getName() {
        return Messages.getString("PieTab.PIE");
    }

    @Override
    public String getMessage() {
        return Messages.getString("PieTab.MESSAGE");
    }

    @Override
    public void performFinish() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        JButton jButton = (JButton)actionEvent.getSource();
        Color color = jButton.getBackground();
        color = JColorChooserEx.showDialog(this, string, color);
        jButton.setBackground(color);
    }

    protected JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }
}

