/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.PolarType;
import com.elixirtech.chart2.model.PolarUi;
import com.elixirtech.chart2.ui.CategoryPage;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.PolarTab;
import com.elixirtech.report2.raw.model.ControlSource;

public class PolarPage
extends CategoryPage
implements IChartProvider {
    public static final String NAME = "Polar";
    private PolarTab m_PolarTab;

    public PolarPage() {
        super(NAME);
        this.setTitle(Messages.getString("PolarPage.TITLE"));
    }

    @Override
    protected void buildTabs() {
        super.buildTabs();
        this.setDataTabShowNumeric(true);
        this.updateMessage();
    }

    @Override
    protected void buildCategoryTabs() {
        this.m_PolarTab = new PolarTab();
        this.addTab(this.m_PolarTab);
    }

    @Override
    protected void updatePanels() {
        super.updatePanels();
        this.m_PolarTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void init(IChart iChart) {
        super.init(iChart);
        this.m_PolarTab.init(iChart);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        this.m_PolarTab.exited();
        super.applyChanges(iChart);
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof PolarType)) {
            PolarType polarType = new PolarType();
            polarType.setKeySource(new ControlSource());
            polarType.setValueSource(new ControlSourceList());
            PolarUi polarUi = new PolarUi();
            polarUi.init();
            polarType.setPolarUi(polarUi);
            iChart.setChartType((ChartType)polarType);
        }
    }

    @Override
    public boolean hasIntervalMarker() {
        return false;
    }
}

