/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.PolarType;
import com.elixirtech.chart2.model.PolarUi;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;

class PolarTab
extends TabComponent {
    private ArchLayout m_Layout = new ArchLayout();
    private ColorPanel m_Background;
    private AxisPanel m_AxisPanel;
    private PolarUi m_PolarUi;

    public PolarTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("PolarTab.PLOT_BACKGROUND"));
        this.m_AxisPanel = new AxisPanel(Messages.getString("PolarTab.RADIAL_AXIS"));
        this.m_Background.build(this, "bg");
        this.m_AxisPanel.build(this, "radial");
        this.m_Layout.stickTop("bg-button");
        this.m_Layout.putRight("bg-button", "radial-name,bg-name", 10);
        this.m_Layout.alignBelow("radial-label", "bg-button", 5);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return Messages.getString("PolarTab.POLAR");
    }

    @Override
    public String getMessage() {
        return Messages.getString("PolarTab.MESSAGE");
    }

    public void init(IChart iChart) {
        this.m_PolarUi = ((PolarType)iChart.getChartType()).getPolarUi();
        this.m_Background.setColor(this.m_PolarUi.getPlotBackground());
        this.m_AxisPanel.setAxis(this.m_PolarUi.getAxis());
    }

    @Override
    public void exited() {
        this.m_PolarUi.setPlotBackground(this.m_Background.getColor());
        this.m_PolarUi.setAxis(this.m_AxisPanel.getAxis());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_AxisPanel.setEnabled(bl);
    }

    @Override
    public void performFinish() {
    }
}

