/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.ui.PositionDisplayPanel;
import com.elixirtech.chart2.ui.PositionPanel;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PositionDialog
extends EscapableDialog
implements ActionListener {
    private String m_ChartType;
    private boolean m_bPositive;
    private PositionPanel m_PositionPanel;
    private PositionDisplayPanel m_PositionDisplayPanel;
    private boolean m_IsOk;

    public PositionDialog(JFrame jFrame, String string, Position position, String string2, boolean bl) {
        super(jFrame, string, true);
        this.setDefaultCloseOperation(2);
        this.m_ChartType = string2;
        this.m_bPositive = bl;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_PositionPanel = new PositionPanel();
        this.m_PositionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PositionPanel.setPosition(position);
        container.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JButton jButton = SwingFactory.newOkButton(this);
        jButton.setActionCommand("ok");
        JButton jButton2 = SwingFactory.newCancelButton(this);
        jButton2.setActionCommand("cancel");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        Bundle.ARCH_MAP.injectComponents("PositionDialog.", jPanel2);
        container.add((Component)jPanel2, "South");
        this.m_PositionDisplayPanel = new PositionDisplayPanel(bl);
        jPanel.add("Center", this.m_PositionPanel);
        jPanel.add("West", this.m_PositionDisplayPanel);
        Dimension dimension = this.m_PositionPanel.getPreferredSize();
        dimension.width += 100;
        this.m_PositionDisplayPanel.setPreferredSize(dimension);
        this.pack();
        Dimension dimension2 = this.getPreferredSize();
        dimension2.width += 150;
        this.setSize(dimension2);
        this.paintDisplay();
        this.m_PositionPanel.addUpdateListener(new UpdateListener());
        this.setResizable(false);
    }

    public void paintDisplay() {
        this.m_PositionDisplayPanel.setPosition(this.getPosition(), this.m_ChartType, this.m_bPositive);
    }

    public Position getPosition() {
        return this.m_PositionPanel.getPosition();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("ok".equals(actionEvent.getActionCommand())) {
            this.m_IsOk = true;
        }
        this.dispose();
    }

    class UpdateListener
    implements ItemListener,
    ChangeListener,
    ActionListener {
        UpdateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            PositionDialog.this.paintDisplay();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            PositionDialog.this.paintDisplay();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PositionDialog.this.paintDisplay();
        }
    }
}

