/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.renderer.CategoryRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class PositionDisplayPanel
extends JPanel {
    private String m_ChartType;
    private BufferedImage m_Image;
    private boolean m_bPositive;

    public PositionDisplayPanel(boolean bl) {
        this.m_bPositive = bl;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void setPosition(Position position, String string, boolean bl) {
        Position position2 = position;
        this.m_ChartType = string;
        if (position2 == null) {
            position2 = bl ? CategoryRenderer.getPositivePosition((String)string) : CategoryRenderer.getNegativePosition((String)string);
        }
        JFreeChart jFreeChart = new ChartLabelPositionRenderer().getChart(position2);
        Dimension dimension = this.getPreferredSize();
        this.m_Image = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = this.m_Image.createGraphics();
        jFreeChart.draw(graphics2D, (Rectangle2D)new Rectangle(0, 0, dimension.width, dimension.height), new ChartRenderingInfo());
        graphics2D.dispose();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.m_Image == null) {
            return;
        }
        graphics.drawImage(this.m_Image, 0, 0, null, this);
    }

    final class ChartLabelPositionRenderer {
        private Position m_LabelPostion;

        ChartLabelPositionRenderer() {
        }

        public JFreeChart getChart(Position position) {
            this.m_LabelPostion = position;
            return this.createChart(this.createDataset());
        }

        private CategoryDataset createDataset() {
            int n = 1;
            if (!PositionDisplayPanel.this.m_bPositive) {
                n = -1;
            }
            DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
            defaultCategoryDataset.addValue((double)(25 * n), (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
            defaultCategoryDataset.addValue((double)(10 * n), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1));
            defaultCategoryDataset.addValue((double)(15 * n), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2));
            defaultCategoryDataset.addValue(0.0, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
            defaultCategoryDataset.addValue((double)(-5 * n), (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4));
            return defaultCategoryDataset;
        }

        private JFreeChart createChart(CategoryDataset categoryDataset) {
            CategoryPlot categoryPlot;
            JFreeChart jFreeChart = null;
            if (PositionDisplayPanel.this.m_ChartType.contains("Bar")) {
                jFreeChart = ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
            } else if (PositionDisplayPanel.this.m_ChartType.contains("Area")) {
                jFreeChart = ChartFactory.createAreaChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            } else if (PositionDisplayPanel.this.m_ChartType.contains("Line") || PositionDisplayPanel.this.m_ChartType.contains("XY")) {
                jFreeChart = ChartFactory.createLineChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                categoryPlot = (CategoryPlot)jFreeChart.getPlot();
                ((LineAndShapeRenderer)categoryPlot.getRenderer()).setBaseShapesVisible(true);
            } else {
                jFreeChart = PositionDisplayPanel.this.m_ChartType.equals("Waterfall") ? ChartFactory.createWaterfallChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false) : ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            }
            categoryPlot = (CategoryPlot)jFreeChart.getPlot();
            categoryPlot.setFixedLegendItems(new LegendItemCollection());
            AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)categoryPlot.getRenderer();
            categoryPlot.getRangeAxis().setTickMarksVisible(true);
            categoryPlot.getDomainAxis().setTickLabelsVisible(false);
            categoryPlot.getRangeAxis().setTickLabelsVisible(false);
            StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
            abstractCategoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)standardCategoryItemLabelGenerator);
            ItemLabelPosition itemLabelPosition = CategoryRenderer.build((Position)this.m_LabelPostion);
            abstractCategoryItemRenderer.setBasePositiveItemLabelPosition(itemLabelPosition);
            abstractCategoryItemRenderer.setBaseNegativeItemLabelPosition(itemLabelPosition);
            abstractCategoryItemRenderer.setBaseItemLabelsVisible(true);
            return jFreeChart;
        }
    }
}

