/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.renderer.ItemAnchorUtil;
import com.elixirtech.chart2.renderer.TextAnchorUtil;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.PositionDialog;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.util.CodeBlock;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PositionPanel
extends JPanel {
    private static final String DEF = "def";
    private static final String POS = "pos";
    private static final String ANC = "anc";
    private static final String ROT = "rot";
    private static final String ANG = "ang";
    private ArchLayout m_Layout = new ArchLayout();
    private JCheckBox m_Default;
    private I18NComboBox m_ValuePosition;
    private I18NComboBox m_ValueAnchor;
    private I18NComboBox m_ValuePivot;
    private JSpinner m_Angle;

    public PositionPanel() {
        this.setLayout(this.m_Layout);
        String[] stringArray = ItemAnchorUtil.names();
        String[] stringArray2 = ItemAnchorUtil.keys();
        String[] stringArray3 = TextAnchorUtil.names();
        String[] stringArray4 = TextAnchorUtil.keys();
        this.m_Default = new JCheckBox(Messages.getString("PositionPanel.DEFAULT"));
        this.m_Default.addActionListener(new CodeBlock((Object)this, "checkEnabled"));
        this.m_ValuePosition = I18NComboBox.apply(I18NComboBox.buildNames(stringArray, I18N.CHART_UI, stringArray2));
        Name[] nameArray = I18NComboBox.buildNames(stringArray3, I18N.CHART_UI, stringArray4);
        this.m_ValueAnchor = I18NComboBox.apply(nameArray);
        this.m_ValuePivot = I18NComboBox.apply(nameArray);
        this.m_Angle = new JSpinner(new SpinnerNumberModel(0, -360, 360, 1));
        this.m_Layout.addLabel((JComponent)this, POS, new JLabel(Messages.getString("PositionPanel.POSITION")));
        this.m_Layout.addLabel((JComponent)this, ANC, new JLabel(Messages.getString("PositionPanel.ANCHOR")));
        this.m_Layout.addLabel((JComponent)this, ROT, new JLabel(Messages.getString("PositionPanel.PIVOT")));
        this.m_Layout.addLabel((JComponent)this, ANG, new JLabel(Messages.getString("PositionPanel.ANGLE")));
        this.add(DEF, this.m_Default);
        this.add(POS, this.m_ValuePosition);
        this.add(ANC, this.m_ValueAnchor);
        this.add(ROT, this.m_ValuePivot);
        this.add(ANG, this.m_Angle);
        this.m_Layout.stickTop(DEF);
        this.m_Layout.stickLeft(DEF);
        this.m_Layout.putBelow(POS, DEF, 5);
        this.m_Layout.putRight(POS, "pos-label,anc-label,rot-label,ang-label", 5);
        this.m_Layout.alignBelow(ANC, POS);
        this.m_Layout.alignBelow(ROT, ANC);
        this.m_Layout.alignBelow(ANG, ROT);
        this.m_Layout.stickRight(POS);
        this.m_Layout.stickRight(ANC);
        this.m_Layout.stickRight(ROT);
        this.m_Layout.stickRight(ANG);
        this.checkEnabled();
    }

    public void addUpdateListener(PositionDialog.UpdateListener updateListener) {
        this.m_ValueAnchor.addItemListener(updateListener);
        this.m_ValuePosition.addItemListener(updateListener);
        this.m_ValuePivot.addItemListener(updateListener);
        this.m_Default.addActionListener(updateListener);
        this.m_Angle.addChangeListener(updateListener);
    }

    public void setPosition(Position position) {
        if (position != null) {
            this.m_Default.setSelected(false);
            this.m_ValuePosition.setSelectedId(position.getPosition());
            this.m_ValueAnchor.setSelectedId(position.getAnchor());
            this.m_ValuePivot.setSelectedId(position.getPivot());
            this.m_Angle.setValue(position.getAngle());
        } else {
            this.m_Default.setSelected(true);
        }
        this.checkEnabled();
    }

    public Position getPosition() {
        if (this.m_Default.isSelected()) {
            return null;
        }
        Position position = new Position();
        position.setPosition(this.m_ValuePosition.getSelectedId());
        position.setAnchor(this.m_ValueAnchor.getSelectedId());
        position.setPivot(this.m_ValuePivot.getSelectedId());
        position.setAngle(((Integer)this.m_Angle.getValue()).intValue());
        return position;
    }

    public void checkEnabled() {
        boolean bl = !this.m_Default.isSelected();
        this.m_ValuePosition.setEnabled(bl);
        this.m_ValueAnchor.setEnabled(bl);
        this.m_ValuePivot.setEnabled(bl);
        this.m_Angle.setEnabled(bl);
    }
}

