/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.LimnPlot;
import com.elixirtech.chart2.ui.PreviewTab;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class Preview3dTab
extends PreviewTab {
    private double DISTANCE = 3.0;
    private double ANGLE = Math.PI / 180;
    protected Angle3d m_CameraAngle;

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_CameraAngle = LimnPlot.DefaultCameraAngle();
        ML mL = new ML();
        this.addMouseListener(mL);
        this.addMouseMotionListener(mL);
        this.setToolTipText("Click and drag the mouse to change the camera angle");
    }

    @Override
    public void setCameraAngle(Angle3d angle3d) {
        this.m_CameraAngle = angle3d.makeClone();
    }

    @Override
    public Angle3d getCameraAngle() {
        return this.m_CameraAngle.makeClone();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.m_Chart != null) {
            LimnPlot limnPlot = (LimnPlot)this.m_Chart.getPlot();
            limnPlot.setCameraAngle(this.m_CameraAngle);
        }
        super.paintComponent(graphics);
    }

    private class ML
    extends MouseAdapter
    implements MouseMotionListener {
        private Point m_DownPt;
        private Angle3d m_StartPosition;

        private ML() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (Preview3dTab.this.m_Chart != null) {
                this.m_DownPt = mouseEvent.getPoint();
                this.m_StartPosition = Preview3dTab.this.m_CameraAngle.makeClone();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_DownPt = null;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (Preview3dTab.this.m_Chart != null && this.m_DownPt != null) {
                Point point = mouseEvent.getPoint();
                int n = point.x - this.m_DownPt.x;
                int n2 = point.y - this.m_DownPt.y;
                Angle3d angle3d = this.m_StartPosition.makeClone();
                angle3d.x -= (double)n2 / Preview3dTab.this.DISTANCE * Preview3dTab.this.ANGLE;
                angle3d.y -= (double)n / Preview3dTab.this.DISTANCE * Preview3dTab.this.ANGLE;
                angle3d.x = Math.max(0.0, angle3d.x);
                angle3d.y = Math.max(0.0, angle3d.y);
                angle3d.x = Math.min(1.5707963267948966, angle3d.x);
                angle3d.y = Math.min(1.5707963267948966, angle3d.y);
                Preview3dTab.this.m_CameraAngle = angle3d;
                Preview3dTab.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

