/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.data.ChartDataFactory;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.ChartRenderFactory;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.ui.ChooseChartPage;
import com.elixirtech.chart2.ui.IPreviewTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.RecordExtractor;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ToolTipManager;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;

public class PreviewTab
extends TabComponent
implements IPreviewTab {
    protected static final String MESSAGE = Messages.getString("PreviewTab.MESSAGE");
    protected IWizard m_Wizard;
    protected JFreeChart m_Chart;
    protected ChartRenderingInfo m_ChartRenderingInfo;
    protected String m_Message;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PreviewTab.class);

    @Override
    public void setWizard(IWizard iWizard) {
        this.m_Wizard = iWizard;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.m_Message = MESSAGE;
    }

    @Override
    public String getName() {
        return Messages.getString("PreviewTab.PREVIEW");
    }

    @Override
    public String getMessage() {
        return this.m_Message;
    }

    @Override
    public void setCameraAngle(Angle3d angle3d) {
    }

    @Override
    public Angle3d getCameraAngle() {
        return null;
    }

    @Override
    public void entered() {
        ToolTipManager.sharedInstance().registerComponent(this);
        ChooseChartPage chooseChartPage = (ChooseChartPage)this.m_Wizard.getPage("ChooseChart");
        IChart iChart = chooseChartPage.getChart();
        AbstractChartRenderer abstractChartRenderer = ChartRenderFactory.getRenderer((IChart)iChart);
        this.render(iChart, abstractChartRenderer);
        this.m_Message = MESSAGE;
    }

    protected void render(IChart iChart, AbstractChartRenderer abstractChartRenderer) {
        block9: {
            if (abstractChartRenderer != null) {
                try {
                    IChartData iChartData = (IChartData)this.m_Wizard;
                    String string = iChartData.getDataSourcePath();
                    String string2 = iChartData.getDataSourceRange();
                    DatasetHolder datasetHolder = null;
                    if ("Record".equals(string2)) {
                        DataRecord dataRecord = PreviewTab.getFirstRecord(string);
                        if (dataRecord != null) {
                            DataTable dataTable = new DataTable("dummy", dataRecord.getSchema(), new DataRecord[]{dataRecord});
                            datasetHolder = ChartDataFactory.getDatasetHolder((DataTable)dataTable, (IChart)iChart);
                        }
                    } else if (string != null) {
                        datasetHolder = ChartDataFactory.getDatasetHolder((String)string, (IChart)iChart);
                    }
                    if (datasetHolder != null) {
                        this.m_Chart = abstractChartRenderer.getChart(null, datasetHolder);
                        break block9;
                    }
                    m_Log.warn((Object)"No dataset available");
                }
                catch (Exception exception) {
                    m_Log.warn((Object)("Preview error: " + String.valueOf(exception)), (Throwable)exception);
                    this.m_Chart = null;
                    this.m_Message = Messages.getString("PreviewTab.ERROR1") + String.valueOf(exception);
                }
            } else {
                m_Log.warn((Object)"No renderer available");
            }
        }
    }

    @Override
    public void exited() {
        super.exited();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.m_Chart != null) {
            Rectangle rectangle = this.getBounds();
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, rectangle.width, rectangle.height);
            this.m_ChartRenderingInfo = new ChartRenderingInfo();
            this.m_Chart.draw((Graphics2D)graphics, (Rectangle2D)float_, this.m_ChartRenderingInfo);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        ChartEntity chartEntity = this.getEntity(mouseEvent.getPoint());
        if (chartEntity != null) {
            return chartEntity.getToolTipText();
        }
        return null;
    }

    protected ChartEntity getEntity(Point point) {
        if (this.m_ChartRenderingInfo != null) {
            EntityCollection entityCollection = this.m_ChartRenderingInfo.getEntityCollection();
            ChartEntity chartEntity = entityCollection.getEntity((double)point.x, (double)point.y);
            return chartEntity;
        }
        return null;
    }

    @Override
    public void performFinish() {
    }

    protected static DataRecord getFirstRecord(String string) {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
            return RecordExtractor.getRecord((IDataSource)iDataSource, (int)0);
        }
        catch (DataException dataException) {
            m_Log.error((Object)("getFirstRecord: " + String.valueOf((Object)dataException)), (Throwable)dataException);
            return null;
        }
    }
}

