/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.chart2.ui.IDataPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.FunctionFactory;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.DoubleClickListener;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ScriptPanel
extends JPanel
implements IDataPanel {
    private static final String SCRIPT_PREFIX = "=";
    private boolean m_ShowOperation;
    private JEditor m_Editor;
    private JComboBox m_Operation;

    public ScriptPanel(boolean bl) {
        this.m_ShowOperation = bl;
        this.m_Editor = new JEditor("", REJavaScriptTypes.kit());
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.m_Editor));
        if (this.m_ShowOperation) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.add((Component)new JLabel(Messages.getString("ScriptPanel.OPERATION")), "West");
            this.m_Operation = new JComboBox(this.getOperations());
            this.m_Operation.setRenderer(new FunctionFactory.FunctionLCR());
            jPanel.add((Component)this.m_Operation, "Center");
            this.add((Component)jPanel, "South");
        }
    }

    @Override
    public boolean isOk() {
        return true;
    }

    @Override
    public void setControlSource(ControlSource controlSource) {
        String string = controlSource.getText().trim();
        if (string.startsWith(SCRIPT_PREFIX)) {
            string = string.substring(SCRIPT_PREFIX.length());
        }
        this.m_Editor.setText(string);
        if (this.m_ShowOperation) {
            this.m_Operation.setSelectedItem(controlSource.getOperation());
            if (this.m_Operation.getSelectedIndex() < 0) {
                IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
                this.m_Operation.setSelectedItem(iFunctionFactory.getFunction(DataType.DOUBLE, "First").getName());
            }
        }
    }

    @Override
    public void addDoubleClickListener(DoubleClickListener doubleClickListener) {
    }

    @Override
    public void update(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Editor.setEnabled(bl);
        if (this.m_ShowOperation) {
            this.m_Operation.setEnabled(bl);
        }
    }

    @Override
    public ControlSource getControlSource() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Script");
        Object object = this.m_Editor.getText().trim();
        if (!((String)object).startsWith(SCRIPT_PREFIX)) {
            object = SCRIPT_PREFIX + (String)object;
        }
        controlSource.setText((String)object);
        if (this.m_ShowOperation) {
            controlSource.setOperation((String)this.m_Operation.getSelectedItem());
        } else {
            controlSource.setOperation(null);
        }
        return controlSource;
    }

    protected ComboBoxModel getOperations() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        Function[] functionArray = iFunctionFactory.getAll();
        for (int i = 0; i < functionArray.length; ++i) {
            defaultComboBoxModel.addElement(functionArray[i].getName());
        }
        return defaultComboBoxModel;
    }
}

