/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

public class ScriptTab
extends TabComponent {
    private JEditor m_Editor;
    private TypeSpecificPage m_Page;
    private boolean m_Initialized;

    public ScriptTab(TypeSpecificPage typeSpecificPage) {
        this.m_Page = typeSpecificPage;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.m_Editor = new JEditor("", REJavaScriptTypes.kit());
        this.add(new JScrollPane(this.m_Editor));
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_Editor.setEnabled(bl);
    }

    @Override
    public String getName() {
        return Messages.getString("ScriptTab.SCRIPT");
    }

    @Override
    public String getMessage() {
        return Messages.getString("ScriptTab.MESSAGE");
    }

    public void setScript(Script script) {
        if (script != null) {
            this.m_Editor.setText(script.getText());
        }
    }

    public Script getScript() {
        return new Script("javascript", this.m_Editor.getText());
    }

    @Override
    public void performFinish() {
    }

    @Override
    public void entered() {
        this.setScript(this.m_Page.getChart().getOnConfigure());
        this.m_Initialized = true;
    }

    @Override
    public void exited() {
        if (this.m_Initialized) {
            this.m_Page.getChart().setOnConfigure(this.getScript());
        }
    }

    public void updatePanels(IWizard iWizard) {
        this.m_Editor.setEnabled(!iWizard.isReadOnly());
    }
}

