/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.Category3dType;
import com.elixirtech.chart2.model.Category3dUi;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.ICategory3dType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.IPreviewTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.ScriptTab;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.util.ClassUtil;

public abstract class ThreeDCategoryPage
extends TypeSpecificPage
implements IFinishPage {
    protected DataTab m_XTab;
    protected DataTab m_YTab;
    protected DataTab m_ZTab;
    protected TitleTab m_TitleTab;
    protected LegendTab m_LegendTab;

    public ThreeDCategoryPage(String string) {
        super(string);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_XTab = new DataTab(Messages.getString("3DCategoryPage.X"), 7, false){

            @Override
            public void exited() {
                ICategory3dType iCategory3dType = (ICategory3dType)ThreeDCategoryPage.this.getChart().getChartType();
                iCategory3dType.setXSource(this.getControlSource());
            }
        };
        this.addTab(this.m_XTab);
        this.m_YTab = new DataTab(Messages.getString("3DCategoryPage.Y"), 7, false){

            @Override
            public void exited() {
                ICategory3dType iCategory3dType = (ICategory3dType)ThreeDCategoryPage.this.getChart().getChartType();
                iCategory3dType.setYSource(this.getControlSource());
            }
        };
        this.m_YTab.setShowNumeric(true);
        this.addTab(this.m_YTab);
        this.m_ZTab = new DataTab(Messages.getString("3DCategoryPage.Z"), 7, false){

            @Override
            public void exited() {
                ICategory3dType iCategory3dType = (ICategory3dType)ThreeDCategoryPage.this.getChart().getChartType();
                iCategory3dType.setZSource(this.getControlSource());
            }
        };
        this.addTab(this.m_ZTab);
        this.buildCategoryTabs();
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = ThreeDCategoryPage.this.getChart().getChartType();
                chartType.setTitle(ThreeDCategoryPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = ThreeDCategoryPage.this.getChart().getChartType();
                chartType.setLegend(ThreeDCategoryPage.this.m_LegendTab.getLegend());
            }
        };
        this.addTab(this.m_LegendTab);
        this.m_ScriptTab = new ScriptTab(this);
        this.addTab(this.m_ScriptTab);
        this.m_PreviewTab = (IPreviewTab)ClassUtil.newInstance("com.elixirtech.chart2.ui.Preview3dTab");
        if (this.m_PreviewTab != null) {
            this.m_PreviewTab.setWizard(this.m_Wizard);
            this.addTab(this.m_PreviewTab);
        }
    }

    protected abstract void buildCategoryTabs();

    protected void updatePanels() {
        this.m_XTab.updatePanels(this.m_Wizard);
        this.m_YTab.updatePanels(this.m_Wizard);
        this.m_ZTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void init(IChart iChart) {
        ICategory3dType iCategory3dType = (ICategory3dType)iChart.getChartType();
        this.m_XTab.setControlSource(iCategory3dType.getXSource());
        this.m_YTab.setControlSource(iCategory3dType.getYSource());
        this.m_ZTab.setControlSource(iCategory3dType.getZSource());
        this.m_TitleTab.setTitle(iCategory3dType.getTitle());
        this.m_LegendTab.setLegend(iCategory3dType.getLegend());
        Category3dUi category3dUi = iCategory3dType.getCategory3dUi();
        Angle3d angle3d = new Angle3d(category3dUi.getCameraX(), category3dUi.getCameraY(), category3dUi.getCameraZ());
        if (this.m_PreviewTab != null) {
            this.m_PreviewTab.setCameraAngle(angle3d);
        }
        super.init(iChart);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        ICategory3dType iCategory3dType = (ICategory3dType)iChart.getChartType();
        iCategory3dType.setXSource(this.m_XTab.getControlSource());
        iCategory3dType.setYSource(this.m_YTab.getControlSource());
        iCategory3dType.setZSource(this.m_ZTab.getControlSource());
        iCategory3dType.setTitle(this.m_TitleTab.getTitle());
        iCategory3dType.setLegend(this.m_LegendTab.getLegend());
        if (this.m_PreviewTab != null) {
            Angle3d angle3d = this.m_PreviewTab.getCameraAngle();
            Category3dUi category3dUi = iCategory3dType.getCategory3dUi();
            category3dUi.setCameraX(angle3d.x);
            category3dUi.setCameraY(angle3d.y);
            category3dUi.setCameraZ(angle3d.z);
        }
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof ICategory3dType)) {
            Category3dType category3dType = new Category3dType();
            category3dType.setXSource(new ControlSource());
            category3dType.setYSource(new ControlSource());
            category3dType.setZSource(new ControlSource());
            Category3dUi category3dUi = new Category3dUi();
            category3dUi.init();
            category3dType.setCategory3dUi(category3dUi);
            iChart.setChartType((ChartType)category3dType);
        }
    }
}

