/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.Category3dType;
import com.elixirtech.chart2.model.Category3dUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;

abstract class ThreeDCategoryTab
extends TabComponent {
    public static final String BG_BUTTON = "bg-button";
    public static final String LABELS = "x-name,y-name,z-name,bg-name";
    public static final String X_LABEL = "x-label";
    public static final String Y_LABEL = "y-label";
    public static final String Z_LABEL = "z-label";
    public static final String X_ORDER = "x-order";
    public static final String Z_ORDER = "z-order";
    protected ArchLayout m_Layout = new ArchLayout();
    protected ColorPanel m_Background;
    protected AxisPanel m_XAxisPanel;
    protected AxisPanel m_YAxisPanel;
    protected AxisPanel m_ZAxisPanel;
    protected JCheckBox m_RetainXOrder;
    protected JCheckBox m_RetainZOrder;
    protected IChart m_Chart;
    protected Category3dUi m_CategoryUi;

    public ThreeDCategoryTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("CategoryTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("CategoryTab.X_AXIS"));
        this.m_YAxisPanel = new AxisPanel(Messages.getString("CategoryTab.Y_AXIS"));
        this.m_ZAxisPanel = new AxisPanel(Messages.getString("CategoryTab.Z_AXIS"));
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_YAxisPanel.build(this, "y");
        this.m_ZAxisPanel.build(this, "z");
        if (this.hasRetain()) {
            this.m_RetainXOrder = new JCheckBox(Messages.getString("3DCategoryTab.RETAIN_X_ORDER"));
            this.m_RetainZOrder = new JCheckBox(Messages.getString("3DCategoryTab.RETAIN_Z_ORDER"));
            this.add(X_ORDER, this.m_RetainXOrder);
            this.add(Z_ORDER, this.m_RetainZOrder);
        }
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, LABELS, 10);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 5);
        this.m_Layout.alignBelow(Y_LABEL, X_LABEL, 5);
        this.m_Layout.alignBelow(Z_LABEL, Y_LABEL, 5);
        if (this.hasRetain()) {
            this.m_Layout.alignBelow(X_ORDER, Z_LABEL);
            this.m_Layout.alignBelow(Z_ORDER, X_ORDER);
        }
    }

    public void init(IChart iChart) {
        this.m_Chart = iChart;
        Category3dType category3dType = (Category3dType)iChart.getChartType();
        this.m_CategoryUi = category3dType.getCategory3dUi();
        this.m_Background.setColor(this.m_CategoryUi.getPlotBackground());
        if (this.hasRetain()) {
            this.m_RetainXOrder.setSelected(category3dType.isRetainXOrder());
            this.m_RetainZOrder.setSelected(category3dType.isRetainZOrder());
        }
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
        this.m_YAxisPanel.setEnabled(bl);
        this.m_ZAxisPanel.setEnabled(bl);
        if (this.hasRetain()) {
            this.m_RetainXOrder.setEnabled(bl);
            this.m_RetainZOrder.setEnabled(bl);
        }
    }

    protected JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getMessage();

    @Override
    public void exited() {
        this.m_CategoryUi.setPlotBackground(this.m_Background.getColor());
        Category3dType category3dType = (Category3dType)this.m_Chart.getChartType();
        if (this.hasRetain()) {
            category3dType.setRetainXOrder(this.m_RetainXOrder.isSelected());
            category3dType.setRetainZOrder(this.m_RetainZOrder.isSelected());
        }
    }

    @Override
    public void performFinish() {
    }

    protected boolean hasRetain() {
        return true;
    }
}

