/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.Category3dUi;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Scatter3dType;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.Preview3dTab;
import com.elixirtech.chart2.ui.ScatterTab;
import com.elixirtech.chart2.ui.ScriptTab;
import com.elixirtech.chart2.ui.ThreeDScatterPage$;
import com.elixirtech.chart2.ui.ThreeDScatterTab;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ThreeDScatterPage
extends TypeSpecificPage {
    private final DataTab keyTab;
    private final DataTab xTab;
    private final DataTab yTab;
    private final DataTab zTab;
    private final ThreeDScatterTab scatterTab;
    private final TitleTab titleTab;
    private final LegendTab legendTab;
    private final ScriptTab scriptTab;
    private final Preview3dTab previewTab;
    private final List panels;

    public static int FieldMask() {
        return ThreeDScatterPage$.MODULE$.FieldMask();
    }

    public static String NAME() {
        return ThreeDScatterPage$.MODULE$.NAME();
    }

    public ThreeDScatterPage() {
        super(ThreeDScatterPage$.MODULE$.NAME());
        this.setTitle(Messages.getString("3DScatterPage.SCATTER_CHART"));
        this.keyTab = new ScatterTab(this){
            private final /* synthetic */ ThreeDScatterPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(Messages.getString("3DScatterPage.KEY"), ThreeDScatterPage$.MODULE$.FieldMask(), false);
            }

            public void exited() {
                this.$outer.getChartType().setKeySource(this.getControlSource());
            }
        };
        this.xTab = new ScatterTab(this){
            private final /* synthetic */ ThreeDScatterPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(Messages.getString("3DCategoryPage.X"), ThreeDScatterPage$.MODULE$.FieldMask(), false);
                this.setShowNumeric(true);
            }

            public void exited() {
                this.$outer.getChartType().setXSource(this.getControlSource());
            }
        };
        this.yTab = new ScatterTab(this){
            private final /* synthetic */ ThreeDScatterPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(Messages.getString("3DCategoryPage.Y"), ThreeDScatterPage$.MODULE$.FieldMask(), false);
                this.setShowNumeric(true);
            }

            public void exited() {
                this.$outer.getChartType().setYSource(this.getControlSource());
            }
        };
        this.zTab = new ScatterTab(this){
            private final /* synthetic */ ThreeDScatterPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(Messages.getString("3DCategoryPage.Z"), ThreeDScatterPage$.MODULE$.FieldMask(), false);
                this.setShowNumeric(true);
            }

            public void exited() {
                this.$outer.getChartType().setZSource(this.getControlSource());
            }
        };
        this.scatterTab = new ThreeDScatterTab(this);
        this.titleTab = new ScatterTab(this){
            private final /* synthetic */ ThreeDScatterPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void exited() {
                ChartType ctype = this.$outer.getChart().getChartType();
                ctype.setTitle(this.getTitle());
            }
        };
        this.legendTab = new ScatterTab(this){
            private final /* synthetic */ ThreeDScatterPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void exited() {
                ChartType ctype = this.$outer.getChart().getChartType();
                ctype.setLegend(this.getLegend());
            }
        };
        this.scriptTab = new ScatterTab(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer);
            }
        };
        this.previewTab = new ScatterTab(){

            public void updatePanels(IWizard wiz) {
            }
        };
        this.m_ScriptTab = this.scriptTab();
        this.m_PreviewTab = this.previewTab();
        this.panels = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new TabComponent[]{this.keyTab(), this.xTab(), this.yTab(), this.zTab(), this.scatterTab(), this.titleTab(), this.legendTab(), this.previewTab()}));
    }

    public Scatter3dType getChartType() {
        return (Scatter3dType)this.getChart().getChartType();
    }

    public DataTab keyTab() {
        return this.keyTab;
    }

    public DataTab xTab() {
        return this.xTab;
    }

    public DataTab yTab() {
        return this.yTab;
    }

    public DataTab zTab() {
        return this.zTab;
    }

    public ThreeDScatterTab scatterTab() {
        return this.scatterTab;
    }

    public TitleTab titleTab() {
        return this.titleTab;
    }

    public LegendTab legendTab() {
        return this.legendTab;
    }

    public ScriptTab scriptTab() {
        return this.scriptTab;
    }

    public Preview3dTab previewTab() {
        return this.previewTab;
    }

    public List<TabComponent> panels() {
        return this.panels;
    }

    @Override
    public void buildTabs() {
        this.previewTab().setWizard(this.m_Wizard);
        this.panels().foreach((Function1)(JProcedure1 & Serializable)c -> this.addTab((ITabComponent)c));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            IChart chart = this.getChart();
            this.ensureChartType(chart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(chart);
            }
        }
        super.setVisible(b);
    }

    public void updatePanels() {
        this.panels().foreach((Function1)(JProcedure1 & Serializable)_$1 -> ((ScatterTab)((Object)_$1)).updatePanels(this.m_Wizard));
    }

    @Override
    public void init(IChart chart) {
        Scatter3dType ctype = this.getChartType();
        this.keyTab().setControlSource(ctype.getKeySource());
        this.xTab().setControlSource(ctype.getXSource());
        this.yTab().setControlSource(ctype.getYSource());
        this.zTab().setControlSource(ctype.getZSource());
        this.scatterTab().init(chart);
        this.titleTab().setTitle(ctype.getTitle());
        this.legendTab().setLegend(ctype.getLegend());
        Category3dUi ui = ctype.getCategory3dUi();
        Angle3d angle = new Angle3d(ui.getCameraX(), ui.getCameraY(), ui.getCameraZ());
        this.previewTab().setCameraAngle(angle);
        this.scriptTab().setScript(chart.getOnConfigure());
        this.m_Initialized = true;
    }

    @Override
    public void applyChanges(IChart chart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        Scatter3dType ctype = this.getChartType();
        ctype.setXSource(this.xTab().getControlSource());
        ctype.setYSource(this.yTab().getControlSource());
        ctype.setZSource(this.zTab().getControlSource());
        ctype.setTitle(this.titleTab().getTitle());
        ctype.setLegend(this.legendTab().getLegend());
        chart.setOnConfigure(this.scriptTab().getScript());
        Angle3d angle = this.m_PreviewTab.getCameraAngle();
        Category3dUi ui = ctype.getCategory3dUi();
        ui.setCameraX(angle.x);
        ui.setCameraY(angle.y);
        ui.setCameraZ(angle.z);
    }

    @Override
    public void ensureChartType(IChart chart) {
        ChartType chartType = chart.getChartType();
        if (chartType instanceof Scatter3dType) {
            Scatter3dType ct = (Scatter3dType)chartType;
            return;
        }
        Scatter3dType ctype = new Scatter3dType();
        ctype.setKeySource(new ControlSource());
        ctype.setXSource(new ControlSource());
        ctype.setYSource(new ControlSource());
        ctype.setZSource(new ControlSource());
        Category3dUi ui = new Category3dUi();
        ui.init();
        ctype.setCategory3dUi(ui);
        chart.setChartType((ChartType)ctype);
    }
}

