/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Scatter3dType;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.ScatterTab;
import com.elixirtech.chart2.ui.ThreeDCategoryTab;
import com.elixirtech.chart2.ui.ThreeDScatterPage;

public class ThreeDScatterTab
extends ThreeDCategoryTab
implements ScatterTab {
    public ThreeDScatterTab(ThreeDScatterPage page) {
    }

    @Override
    public String getName() {
        return Messages.getString("3DScatterTab.SCATTER");
    }

    @Override
    public String getMessage() {
        return Messages.getString("3DScatterTab.CHOOSE_VALUES");
    }

    @Override
    public void init(IChart chart) {
        this.m_Chart = chart;
        Scatter3dType ctype = (Scatter3dType)this.m_Chart.getChartType();
        this.m_CategoryUi = ctype.getCategory3dUi();
        this.m_Background.setColor(this.m_CategoryUi.getPlotBackground());
        if (this.hasRetain()) {
            this.m_RetainXOrder.setSelected(ctype.isRetainXOrder());
            this.m_RetainZOrder.setSelected(ctype.isRetainZOrder());
        }
        this.m_XAxisPanel.setAxis(this.m_CategoryUi.getXAxis());
        this.m_YAxisPanel.setAxis(this.m_CategoryUi.getYAxis());
        this.m_ZAxisPanel.setAxis(this.m_CategoryUi.getZAxis());
    }

    @Override
    public void exited() {
        this.m_CategoryUi.setPlotBackground(this.m_Background.getColor());
        Scatter3dType ctype = (Scatter3dType)this.m_Chart.getChartType();
        if (this.hasRetain()) {
            ctype.setRetainXOrder(this.m_RetainXOrder.isSelected());
            ctype.setRetainZOrder(this.m_RetainZOrder.isSelected());
        }
        this.m_CategoryUi.setXAxis(this.m_XAxisPanel.getAxis());
        this.m_CategoryUi.setYAxis(this.m_YAxisPanel.getAxis());
        this.m_CategoryUi.setZAxis(this.m_ZAxisPanel.getAxis());
    }

    @Override
    public boolean hasRetain() {
        return false;
    }
}

