/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.ChartConstants;
import com.elixirtech.chart2.ChartConstantsUI;
import com.elixirtech.chart2.model.Title;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.FontChooserDialog;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;

public class TitleTab
extends DataTab {
    private static final String TYPE_LABEL = "type-label";
    private static final String TYPE = "type";
    private static final String ANCHOR_LABEL = "anchor-label";
    private static final String ANCHOR = "anchor";
    private static final String COLOR = "color";
    private static final String FONT = "font";
    private JComboBox m_Anchor;
    private JButton m_FontButton;
    private JButton m_ColorButton;
    private com.elixirtech.chart2.model.Font m_Font;

    public TitleTab() {
        super(Messages.getString("TitleTab.TITLE"), 15, false);
    }

    public TitleTab(int n) {
        super(Messages.getString("TitleTab.TITLE"), n, false);
    }

    @Override
    public String getMessage() {
        return Messages.getString("TitleTab.MESSAGE");
    }

    public void setTitle(Title title) {
        if (title != null) {
            this.setAnchor(title.getAnchor());
            this.setControlSource(title.getControlSource());
            this.m_Font = title.getFont();
        } else {
            this.setAnchor("North");
            ControlSource controlSource = new ControlSource();
            controlSource.setType("Literal");
            this.setControlSource(controlSource);
        }
    }

    public Title getTitle() {
        Title title = new Title();
        title.setAnchor(this.getAnchor());
        title.setControlSource(this.getControlSource());
        title.setFont(this.m_Font);
        return title;
    }

    public void setAnchor(String string) {
        int n = ChartConstantsUI.lookup((String)string);
        this.m_Anchor.setSelectedIndex(n);
    }

    public String getAnchor() {
        int n = this.m_Anchor.getSelectedIndex();
        return ChartConstants.ANCHOR_VALUES[n];
    }

    @Override
    public void updatePanels(IWizard iWizard) {
        super.updatePanels(iWizard);
        boolean bl = !iWizard.isReadOnly();
        this.m_Anchor.setEnabled(bl);
        this.m_FontButton.setEnabled(bl);
        this.m_ColorButton.setEnabled(bl);
    }

    @Override
    protected JPanel buildNorth() {
        ArchLayout archLayout = new ArchLayout();
        JPanel jPanel = new JPanel(archLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jPanel.add(TYPE_LABEL, new JLabel(Messages.getString("TitleTab.FIELD_TYPE")));
        this.m_Type = I18NComboBox.apply(this.getTypeNames());
        jPanel.add(TYPE, this.m_Type);
        jPanel.add(ANCHOR_LABEL, new JLabel(Messages.getString("TitleTab.POSITION")));
        this.m_Anchor = new JComboBox<String>(ChartConstantsUI.ANCHOR_VALUES_UI);
        jPanel.add(ANCHOR, this.m_Anchor);
        this.m_FontButton = this.button(new FontAction());
        jPanel.add(FONT, this.m_FontButton);
        this.m_ColorButton = this.button(new ColorAction());
        jPanel.add(COLOR, this.m_ColorButton);
        archLayout.stickTop(TYPE);
        archLayout.vCenter(TYPE_LABEL, TYPE);
        archLayout.vCenter(ANCHOR_LABEL, TYPE);
        archLayout.vCenter(ANCHOR, TYPE);
        archLayout.stickLeft(TYPE_LABEL);
        archLayout.putRight(TYPE, TYPE_LABEL, 10);
        archLayout.putRight(ANCHOR_LABEL, TYPE, 10);
        archLayout.putRight(ANCHOR, ANCHOR_LABEL, 10);
        archLayout.stickTop(COLOR);
        archLayout.stickRight(COLOR);
        archLayout.setHeight(COLOR, ANCHOR);
        archLayout.stickTop(FONT);
        archLayout.putLeft(FONT, COLOR);
        archLayout.setHeight(FONT, ANCHOR);
        return jPanel;
    }

    private JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    private class FontAction
    extends ChartAction {
        public FontAction() {
            super("Chart.Font");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            Font font = TitleTab.this.m_Font != null ? TitleTab.this.m_Font.getAWTFont() : JFreeChart.DEFAULT_TITLE_FONT;
            FontChooserDialog fontChooserDialog = new FontChooserDialog((Frame)elixirFrame.getFrame(), font);
            fontChooserDialog.setTitle(Messages.getString("TitleTab.TITLE_FONT"));
            fontChooserDialog.pack();
            fontChooserDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(fontChooserDialog);
            if (fontChooserDialog.isOk()) {
                font = fontChooserDialog.getSelectedFont();
                String string = null;
                if (TitleTab.this.m_Font != null) {
                    string = TitleTab.this.m_Font.getFontColor();
                }
                TitleTab.this.m_Font = new com.elixirtech.chart2.model.Font(font);
                TitleTab.this.m_Font.setFontColor(string);
            }
        }
    }

    private class ColorAction
    extends ChartAction {
        public ColorAction() {
            super("Chart.Color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = TitleTab.this.m_Font != null ? TitleTab.this.m_Font.getFontColor() : "Black";
            Color color = StandardColor.lookup(string);
            color = JColorChooserEx.showDialog(elixirFrame.getFrame(), Messages.getString("TitleTab.TITLE_COLOR"), color);
            if (TitleTab.this.m_Font == null) {
                TitleTab.this.m_Font = new com.elixirtech.chart2.model.Font(JFreeChart.DEFAULT_TITLE_FONT);
            }
            TitleTab.this.m_Font.setFontColor(StandardColor.getColorName(color));
        }
    }
}

