/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.wizard.TabbedWizardPage;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.ChooseChartPage;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.IPreviewTab;
import com.elixirtech.chart2.ui.ScriptTab;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.ClassUtil;

public abstract class TypeSpecificPage
extends TabbedWizardPage
implements IFinishPage,
IChartProvider {
    protected ScriptTab m_ScriptTab;
    protected IPreviewTab m_PreviewTab;
    protected boolean m_Initialized;

    public TypeSpecificPage(String string) {
        super(string, null);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    @Override
    public void setMessage(String string) {
        super.setMessage(string);
    }

    @Override
    public void setError(String string) {
        super.setError(string);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.buildTabs();
    }

    @Override
    public IChart getChart() {
        ChooseChartPage chooseChartPage = (ChooseChartPage)this.m_Wizard.getPage("ChooseChart");
        return chooseChartPage.getChart();
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        if (this.m_Initialized) {
            this.m_Current.exited();
            IChart iChart = this.getChart();
            this.applyChanges(iChart);
        }
    }

    protected void buildTabs() {
        this.m_ScriptTab = new ScriptTab(this);
        this.addTab(this.m_ScriptTab);
        this.m_PreviewTab = (IPreviewTab)ClassUtil.newInstance("com.elixirtech.chart2.ui.PreviewTab");
        if (this.m_PreviewTab != null) {
            this.m_PreviewTab.setWizard(this.m_Wizard);
            this.addTab(this.m_PreviewTab);
        }
    }

    protected void init(IChart iChart) {
        this.m_ScriptTab.setScript(iChart.getOnConfigure());
        this.m_Initialized = true;
    }

    protected void applyChanges(IChart iChart) {
        if (this.m_Initialized) {
            iChart.setOnConfigure(this.m_ScriptTab.getScript());
        }
    }

    protected IPreviewTab getPreviewTab() {
        return this.m_PreviewTab;
    }

    protected abstract void ensureChartType(IChart var1);
}

