/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.AbstractFormat;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.Value;
import com.elixirtech.chart2.ui.ChartAction;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.FontChooserDialog;
import com.elixirtech.ui.FormatDialog;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.format.IFormat;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.jfree.chart.JFreeChart;

public class ValuePanel
implements ItemListener {
    private JLabel m_Label;
    private ChartAction m_FormatAction;
    private boolean m_StyleEditing;
    private String m_Name;
    private JCheckBox m_Visible;
    private JButton m_FontButton;
    private JButton m_ColorButton;
    private JButton m_FormatButton;
    private JCheckBox m_InvertData;
    private com.elixirtech.chart2.model.Font m_Font;
    private AbstractFormat m_Format;

    public ValuePanel(String string, boolean bl, ChartAction chartAction) {
        this(string, bl);
        this.m_FormatAction = chartAction;
    }

    public ValuePanel(String string, boolean bl) {
        this.m_StyleEditing = bl;
        this.m_Name = string;
        this.m_Visible = new JCheckBox(Messages.getString("ValuePanel.VISIBLE"));
        this.m_Visible.addItemListener(this);
        this.m_InvertData = new JCheckBox(Messages.getString("ValuePanel.INVERT_DATA"));
    }

    public ValuePanel(String string) {
        this(string, true);
    }

    public void build(Container container, String string) {
        if (this.m_StyleEditing) {
            this.m_FontButton = this.button(new FontAction());
            this.m_ColorButton = this.button(new ColorAction());
        }
        if (this.m_FormatAction == null) {
            this.m_FormatAction = new FormatAction();
        }
        this.m_FormatButton = this.button(this.m_FormatAction);
        String string2 = string + "-name";
        String string3 = string + "-value";
        String string4 = string + "-font";
        String string5 = string + "-color";
        String string6 = string + "-format";
        String string7 = string + "-invert";
        this.m_Label = new JLabel(this.m_Name + ":");
        container.add(string2, this.m_Label);
        container.add(string3, this.m_Visible);
        if (this.m_StyleEditing) {
            container.add(string4, this.m_FontButton);
            container.add(string5, this.m_ColorButton);
        }
        container.add(string6, this.m_FormatButton);
        container.add(string7, this.m_InvertData);
        ArchLayout archLayout = (ArchLayout)container.getLayout();
        archLayout.stickLeft(string2);
        if (this.m_StyleEditing) {
            archLayout.putRight(string4, string3, 5);
            archLayout.putRight(string5, string4);
            archLayout.putRight(string6, string5);
            archLayout.putRight(string7, string6, 20);
            archLayout.vCenter(string2, string3);
            archLayout.vCenter(string4, string3);
            archLayout.vCenter(string5, string3);
            archLayout.vCenter(string6, string3);
            archLayout.vCenter(string7, string3);
        } else {
            archLayout.putRight(string6, string3, 5);
            archLayout.putRight(string7, string6);
            archLayout.vCenter(string2, string3);
            archLayout.vCenter(string6, string3);
            archLayout.vCenter(string7, string6);
        }
    }

    public void setValue(Value value) {
        if (value != null) {
            this.m_Visible.setSelected(value.isVisible());
            this.m_Font = value.getFont();
            this.m_Format = value.getFormat();
        } else {
            this.m_Visible.setSelected(true);
        }
        this.checkEnabled();
    }

    public Value getValue() {
        Value value = new Value();
        value.setFont(this.m_Font);
        value.setFormat(this.m_Format);
        value.setVisible(this.m_Visible.isSelected());
        return value;
    }

    public void invertEnabled(boolean bl) {
        this.m_InvertData.setVisible(bl);
    }

    public void setInverted(boolean bl) {
        this.m_InvertData.setSelected(bl);
    }

    public boolean isInverted() {
        return this.m_InvertData.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkEnabled();
    }

    public void setEnabled(boolean bl) {
        this.m_Visible.setEnabled(bl);
        this.m_InvertData.setEnabled(bl);
        this.checkEnabled();
    }

    protected void checkEnabled() {
        boolean bl;
        boolean bl2 = bl = this.m_Visible.isSelected() && this.m_Visible.isEnabled();
        if (this.m_StyleEditing) {
            this.m_FontButton.setEnabled(bl);
            this.m_ColorButton.setEnabled(bl);
        }
        this.m_FormatButton.setEnabled(bl);
    }

    protected JButton button(ChartAction chartAction) {
        JButton jButton = new JButton(chartAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    public void setVisible(boolean bl) {
        this.m_FormatButton.setVisible(bl);
        this.m_Visible.setVisible(bl);
        this.m_Label.setVisible(bl);
    }

    private class FontAction
    extends ChartAction {
        public FontAction() {
            super("Chart.Font");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            Font font = null;
            font = ValuePanel.this.m_Font != null ? ValuePanel.this.m_Font.getAWTFont() : new Font("SansSerif", 0, 10);
            FontChooserDialog fontChooserDialog = new FontChooserDialog((Frame)elixirFrame.getFrame(), font);
            fontChooserDialog.setTitle(Messages.getString("ValuePanel.VALUE_FONT"));
            fontChooserDialog.pack();
            fontChooserDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(fontChooserDialog);
            if (fontChooserDialog.isOk()) {
                font = fontChooserDialog.getSelectedFont();
                String string = null;
                if (ValuePanel.this.m_Font != null) {
                    string = ValuePanel.this.m_Font.getFontColor();
                }
                ValuePanel.this.m_Font = new com.elixirtech.chart2.model.Font(font);
                ValuePanel.this.m_Font.setFontColor(string);
            }
        }
    }

    private class ColorAction
    extends ChartAction {
        public ColorAction() {
            super("Chart.Color");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            String string = ValuePanel.this.m_Font != null ? ValuePanel.this.m_Font.getFontColor() : "Black";
            Color color = StandardColor.lookup(string);
            color = JColorChooserEx.showDialog(elixirFrame.getFrame(), Messages.getString("ValuePanel.TICK_COLOR"), color);
            if (ValuePanel.this.m_Font == null) {
                ValuePanel.this.m_Font = new com.elixirtech.chart2.model.Font(JFreeChart.DEFAULT_TITLE_FONT);
            }
            ValuePanel.this.m_Font.setFontColor(StandardColor.getColorName(color));
        }
    }

    private class FormatAction
    extends ChartAction {
        public FormatAction() {
            super("Chart.Format");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            FormatDialog formatDialog = new FormatDialog(elixirFrame.getFrame(), Messages.getString("ValuePanel.VALUE_FORMAT"), (IFormat)((Format)ValuePanel.this.m_Format), Format.class);
            formatDialog.setLocationRelativeTo(elixirFrame.getFrame());
            elixirFrame.showModal(formatDialog);
            if (formatDialog.isOk()) {
                ValuePanel.this.m_Format = (Format)formatDialog.getFormat();
            }
        }
    }
}

