/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.CategoryUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;

class WaterfallTab
extends TabComponent {
    private ArchLayout m_Layout = new ArchLayout();
    private ColorPanel m_Background;
    private CategoryUi m_CategoryUi;

    public WaterfallTab() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("PolarTab.PLOT_BACKGROUND"));
        this.m_Background.build(this, "bg");
        this.m_Layout.stickTop("bg-button");
        this.m_Layout.putRight("bg-button", "bg-name", 10);
    }

    @Override
    public String getName() {
        return Messages.getString("WaterfallTab.WATERFALL");
    }

    @Override
    public String getMessage() {
        return Messages.getString("WaterfallTab.MESSAGE");
    }

    public void init(IChart iChart) {
        this.m_CategoryUi = ((CategoryType)iChart.getChartType()).getCategoryUi();
        this.m_Background.setColor(this.m_CategoryUi.getPlotBackground());
    }

    @Override
    public void exited() {
        this.m_CategoryUi.setPlotBackground(this.m_Background.getColor());
    }

    @Override
    public void performFinish() {
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
    }
}

