/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.WindType;
import com.elixirtech.chart2.model.WindUi;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.chart2.ui.WindTab;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class WindPage
extends TypeSpecificPage
implements IFinishPage,
IChartProvider {
    public static final String NAME = "Wind";
    protected DataTab m_KeyTab;
    protected DataTab m_DateTab;
    protected DataTab m_DirectionTab;
    protected DataTab m_ForceTab;
    protected WindTab m_WindTab;
    protected TitleTab m_TitleTab;
    protected LegendTab m_LegendTab;

    protected WindPage(String string) {
        super(string);
    }

    public WindPage() {
        super(NAME);
        this.setTitle(Messages.getString("Wind.TITLE"));
    }

    public String getChartTypeName() {
        return Messages.getString("Wind.WIND");
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_KeyTab = new DataTab(I18N.CHART_UI.getString("WindPage.KEY"), 15, false){

            @Override
            public void exited() {
                WindType windType = (WindType)WindPage.this.getChart().getChartType();
                windType.setKeySource(this.getControlSource());
            }
        };
        this.m_DateTab = new DataTab(I18N.CHART_UI.getString("WindPage.WHEN"), 15, false){

            @Override
            public void exited() {
                WindType windType = (WindType)WindPage.this.getChart().getChartType();
                windType.setDateSource(this.getControlSource());
            }
        };
        this.m_DirectionTab = new DataTab(I18N.CHART_UI.getString("WindPage.DIRECTION"), 15, false){

            @Override
            public void exited() {
                WindType windType = (WindType)WindPage.this.getChart().getChartType();
                windType.setDirectionSource(this.getControlSource());
            }
        };
        this.m_ForceTab = new DataTab(I18N.CHART_UI.getString("WindPage.FORCE"), 15, false){

            @Override
            public void exited() {
                WindType windType = (WindType)WindPage.this.getChart().getChartType();
                windType.setForceSource(this.getControlSource());
            }
        };
        this.addTab(this.m_KeyTab);
        this.addTab(this.m_DateTab);
        this.addTab(this.m_DirectionTab);
        this.addTab(this.m_ForceTab);
        this.m_WindTab = new WindTab(this.getChartTypeName());
        this.addTab(this.m_WindTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = WindPage.this.getChart().getChartType();
                chartType.setTitle(WindPage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = WindPage.this.getChart().getChartType();
                chartType.setLegend(WindPage.this.m_LegendTab.getLegend());
            }
        };
        this.addTab(this.m_LegendTab);
        super.buildTabs();
    }

    protected void updatePanels() {
        this.m_KeyTab.updatePanels(this.m_Wizard);
        this.m_DateTab.updatePanels(this.m_Wizard);
        this.m_DirectionTab.updatePanels(this.m_Wizard);
        this.m_ForceTab.updatePanels(this.m_Wizard);
        this.m_WindTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void init(IChart iChart) {
        WindType windType = (WindType)iChart.getChartType();
        this.m_KeyTab.setControlSource(windType.getKeySource());
        this.m_DateTab.setControlSource(windType.getDateSource());
        this.m_DirectionTab.setControlSource(windType.getDirectionSource());
        this.m_ForceTab.setControlSource(windType.getForceSource());
        this.m_WindTab.init(iChart);
        this.m_TitleTab.setTitle(windType.getTitle());
        this.m_LegendTab.setLegend(windType.getLegend());
        super.init(iChart);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        WindType windType = (WindType)iChart.getChartType();
        windType.setKeySource(this.m_KeyTab.getControlSource());
        windType.setDateSource(this.m_DateTab.getControlSource());
        windType.setDirectionSource(this.m_DirectionTab.getControlSource());
        windType.setForceSource(this.m_ForceTab.getControlSource());
        this.m_WindTab.exited();
        windType.setTitle(this.m_TitleTab.getTitle());
        windType.setLegend(this.m_LegendTab.getLegend());
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof WindType)) {
            WindType windType = new WindType();
            windType.setKeySource(new ControlSource());
            windType.setDateSource(new ControlSource());
            windType.setDirectionSource(new ControlSource());
            windType.setForceSource(new ControlSource());
            WindUi windUi = new WindUi();
            windUi.init();
            windType.setWindUi(windUi);
            ((Chart)iChart).setChartType((ChartType)windType);
        }
    }
}

