/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.WindRoseType;
import com.elixirtech.chart2.model.WindRoseUi;
import com.elixirtech.chart2.ui.DataTab;
import com.elixirtech.chart2.ui.IChartProvider;
import com.elixirtech.chart2.ui.LegendTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.TitleTab;
import com.elixirtech.chart2.ui.TypeSpecificPage;
import com.elixirtech.chart2.ui.WindRoseTab;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.wizard.IFinishPage;

public class WindRosePage
extends TypeSpecificPage
implements IFinishPage,
IChartProvider {
    public static final String NAME = "WindRose";
    protected DataTab m_DirectionTab;
    protected DataTab m_ForceTab;
    protected WindRoseTab m_WindTab;
    protected TitleTab m_TitleTab;
    protected LegendTab m_LegendTab;

    protected WindRosePage(String string) {
        super(string);
    }

    public WindRosePage() {
        super(NAME);
        this.setTitle(Messages.getString("WindRose.TITLE"));
    }

    public String getChartTypeName() {
        return Messages.getString("WindRose.WINDROSE");
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            IChart iChart = this.getChart();
            this.ensureChartType(iChart);
            this.updatePanels();
            if (!this.m_Initialized) {
                this.init(iChart);
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected void buildTabs() {
        this.m_DirectionTab = new DataTab(I18N.CHART_UI.getString("WindRosePage.DIRECTION"), 15, false){

            @Override
            public void exited() {
                WindRoseType windRoseType = (WindRoseType)WindRosePage.this.getChart().getChartType();
                windRoseType.setDirectionSource(this.getControlSource());
            }
        };
        this.m_ForceTab = new DataTab(I18N.CHART_UI.getString("WindRosePage.FORCE"), 15, false){

            @Override
            public void exited() {
                WindRoseType windRoseType = (WindRoseType)WindRosePage.this.getChart().getChartType();
                windRoseType.setForceSource(this.getControlSource());
            }
        };
        this.addTab(this.m_DirectionTab);
        this.addTab(this.m_ForceTab);
        this.m_WindTab = new WindRoseTab(this.getChartTypeName());
        this.addTab(this.m_WindTab);
        this.m_TitleTab = new TitleTab(){

            @Override
            public void exited() {
                ChartType chartType = WindRosePage.this.getChart().getChartType();
                chartType.setTitle(WindRosePage.this.m_TitleTab.getTitle());
            }
        };
        this.addTab(this.m_TitleTab);
        this.m_LegendTab = new LegendTab(){

            @Override
            public void exited() {
                ChartType chartType = WindRosePage.this.getChart().getChartType();
                chartType.setLegend(WindRosePage.this.m_LegendTab.getLegend());
            }
        };
        this.addTab(this.m_LegendTab);
        super.buildTabs();
    }

    protected void updatePanels() {
        this.m_DirectionTab.updatePanels(this.m_Wizard);
        this.m_ForceTab.updatePanels(this.m_Wizard);
        this.m_WindTab.updatePanels(this.m_Wizard);
        this.m_TitleTab.updatePanels(this.m_Wizard);
        this.m_LegendTab.updatePanels(this.m_Wizard);
        this.m_ScriptTab.updatePanels(this.m_Wizard);
    }

    @Override
    protected void init(IChart iChart) {
        WindRoseType windRoseType = (WindRoseType)iChart.getChartType();
        this.m_DirectionTab.setControlSource(windRoseType.getDirectionSource());
        this.m_ForceTab.setControlSource(windRoseType.getForceSource());
        this.m_WindTab.init(iChart);
        this.m_TitleTab.setTitle(windRoseType.getTitle());
        this.m_LegendTab.setLegend(windRoseType.getLegend());
        super.init(iChart);
    }

    @Override
    protected void applyChanges(IChart iChart) {
        if (this.m_Current != null) {
            this.m_Current.exited();
        }
        super.applyChanges(iChart);
        WindRoseType windRoseType = (WindRoseType)iChart.getChartType();
        windRoseType.setDirectionSource(this.m_DirectionTab.getControlSource());
        windRoseType.setForceSource(this.m_ForceTab.getControlSource());
        this.m_WindTab.exited();
        windRoseType.setTitle(this.m_TitleTab.getTitle());
        windRoseType.setLegend(this.m_LegendTab.getLegend());
    }

    @Override
    protected void ensureChartType(IChart iChart) {
        if (!(iChart.getChartType() instanceof WindRoseType)) {
            WindRoseType windRoseType = new WindRoseType();
            windRoseType.setDirectionSource(new ControlSource());
            windRoseType.setForceSource(new ControlSource());
            WindRoseUi windRoseUi = new WindRoseUi();
            windRoseUi.init();
            windRoseType.setWindRoseUi(windRoseUi);
            ((Chart)iChart).setChartType((ChartType)windRoseType);
        }
    }
}

