/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.WindRoseType;
import com.elixirtech.chart2.model.WindRoseUi;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;

class WindRoseTab
extends TabComponent {
    public static final String BG_BUTTON = "bg-button";
    private String m_Name;
    private ArchLayout m_Layout = new ArchLayout();
    private ColorPanel m_Background;
    private WindRoseUi m_WindRoseUi;

    public WindRoseTab(String string) {
        this.m_Name = string;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("WindRoseTab.PLOT_BACKGROUND"));
        this.m_Background.build(this, "bg");
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, "bg-name", 10);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getMessage() {
        return Messages.getString("WindTab.MESSAGE");
    }

    public void init(IChart iChart) {
        this.m_WindRoseUi = ((WindRoseType)iChart.getChartType()).getWindRoseUi();
        this.m_Background.setColor(this.m_WindRoseUi.getPlotBackground());
    }

    @Override
    public void exited() {
        this.m_WindRoseUi.setPlotBackground(this.m_Background.getColor());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
    }

    @Override
    public void performFinish() {
    }
}

