/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.WindType;
import com.elixirtech.chart2.model.WindUi;
import com.elixirtech.chart2.ui.AxisPanel;
import com.elixirtech.chart2.ui.ColorPanel;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

class WindTab
extends TabComponent {
    public static final String BG_BUTTON = "bg-button";
    public static final String X_LABEL = "x-label";
    public static final String GRIDLINES_LABEL = "gridlines-label";
    public static final String DOMAIN_GRIDLINES = "domain-gridlines";
    public static final String RANGE_GRIDLINES = "range-gridlines";
    protected JCheckBox m_DomainGridlinesVisible;
    protected JCheckBox m_RangeGridlinesVisible;
    private String m_Name;
    private ArchLayout m_Layout = new ArchLayout();
    private ColorPanel m_Background;
    private AxisPanel m_XAxisPanel;
    private WindUi m_WindUi;

    public WindTab(String string) {
        this.m_Name = string;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.m_Background = new ColorPanel(Messages.getString("WindTab.PLOT_BACKGROUND"));
        this.m_XAxisPanel = new AxisPanel(Messages.getString("WindTab.X_AXIS"));
        this.m_Background.build(this, "bg");
        this.m_XAxisPanel.build(this, "x");
        this.m_Layout.stickTop(BG_BUTTON);
        this.m_Layout.putRight(BG_BUTTON, "x-name,bg-name", 10);
        this.m_Layout.alignBelow(X_LABEL, BG_BUTTON, 5);
        this.m_DomainGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.DOMAIN_GRIDLINES"));
        this.m_RangeGridlinesVisible = new JCheckBox(Messages.getString("CategoryTab.RANGE_GRIDLINES"));
        this.add(GRIDLINES_LABEL, new JLabel(Messages.getString("CategoryTab.SHOW_GRIDLINES")));
        this.add(DOMAIN_GRIDLINES, this.m_DomainGridlinesVisible);
        this.add(RANGE_GRIDLINES, this.m_RangeGridlinesVisible);
        this.m_Layout.stickLeft(GRIDLINES_LABEL);
        this.m_Layout.alignBelow(DOMAIN_GRIDLINES, X_LABEL, 2);
        this.m_Layout.putRight(RANGE_GRIDLINES, DOMAIN_GRIDLINES, 2);
        this.m_Layout.vCenter(GRIDLINES_LABEL, DOMAIN_GRIDLINES);
        this.m_Layout.vCenter(RANGE_GRIDLINES, DOMAIN_GRIDLINES);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getMessage() {
        return Messages.getString("WindTab.MESSAGE");
    }

    public void init(IChart iChart) {
        this.m_WindUi = ((WindType)iChart.getChartType()).getWindUi();
        this.m_Background.setColor(this.m_WindUi.getPlotBackground());
        this.m_XAxisPanel.setAxis(this.m_WindUi.getValueAxis());
        this.m_DomainGridlinesVisible.setSelected(this.m_WindUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(this.m_WindUi.isRangeGridlinesVisible());
    }

    @Override
    public void exited() {
        this.m_WindUi.setPlotBackground(this.m_Background.getColor());
        this.m_WindUi.setValueAxis(this.m_XAxisPanel.getAxis());
        this.m_WindUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_WindUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    public void updatePanels(IWizard iWizard) {
        boolean bl = !iWizard.isReadOnly();
        this.m_Background.setEnabled(bl);
        this.m_XAxisPanel.setEnabled(bl);
    }

    @Override
    public void performFinish() {
    }
}

