/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.model.XYType;
import com.elixirtech.chart2.model.XYUi;
import com.elixirtech.chart2.ui.CategoryTab;
import com.elixirtech.chart2.ui.Messages;
import com.elixirtech.chart2.ui.PositionDialog;
import com.elixirtech.ui.wizard.IWizard;

class XYTab
extends CategoryTab {
    private XYUi m_XYUi;

    XYTab() {
    }

    @Override
    public String getName() {
        return Messages.getString("XYTab.XY");
    }

    @Override
    public String getMessage() {
        return Messages.getString("XYTab.MESSAGE");
    }

    @Override
    public void init(IChart iChart) {
        this.m_Chart = iChart;
        this.m_XYUi = ((XYType)iChart.getChartType()).getXYUi();
        this.m_Background.setColor(this.m_XYUi.getPlotBackground());
        this.m_PositiveDescription.setText(this.describe(this.m_XYUi.getPositivePosition()));
        this.m_NegativeDescription.setText(this.describe(this.m_XYUi.getNegativePosition()));
        Axis axis = this.m_XYUi.getXAxis();
        Axis axis2 = this.m_XYUi.getYAxis();
        this.m_XAxisPanel.setAxis(axis);
        this.m_YAxisPanel.setAxis(axis2);
        this.m_ValuePanel.setValue(this.m_XYUi.getValue());
        this.m_ValuePanel.invertEnabled(false);
        this.m_Key.setVisible(false);
        this.m_RetainKeyOrder.setVisible(false);
        this.m_AddSubCategory.setVisible(false);
        this.m_AxisTickLabelAnglePanel.setDomainTickVertical(true);
        this.m_AxisTickLabelAnglePanel.setAxis(axis);
        this.m_DomainGridlinesVisible.setSelected(this.m_XYUi.isDomainGridlinesVisible());
        this.m_RangeGridlinesVisible.setSelected(this.m_XYUi.isRangeGridlinesVisible());
    }

    @Override
    public void updatePanels(IWizard iWizard) {
        super.updatePanels(iWizard);
        this.m_RetainKeyOrder.setEnabled(false);
    }

    @Override
    public void exited() {
        this.m_XYUi.setPlotBackground(this.m_Background.getColor());
        Axis axis = this.m_XAxisPanel.getAxis();
        Axis axis2 = this.m_YAxisPanel.getAxis();
        this.m_XYUi.setXAxis(axis);
        this.m_XYUi.setYAxis(axis2);
        this.m_AxisTickLabelAnglePanel.updateAxis(axis);
        this.m_XYUi.setValue(this.m_ValuePanel.getValue());
        this.m_XYUi.setDomainGridlinesVisible(this.m_DomainGridlinesVisible.isSelected());
        this.m_XYUi.setRangeGridlinesVisible(this.m_RangeGridlinesVisible.isSelected());
    }

    @Override
    protected void doPositivePosition() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        Position position = this.m_XYUi.getPositivePosition();
        String string = this.m_Chart.getType();
        PositionDialog positionDialog = new PositionDialog(elixirFrame.getFrame(), Messages.getString("XYTab.POSITIVE_POSITION"), position, string, true);
        positionDialog.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(positionDialog);
        if (positionDialog.isOk()) {
            position = positionDialog.getPosition();
            this.m_XYUi.setPositivePosition(position);
            this.m_PositiveDescription.setText(this.describe(position));
        }
    }

    @Override
    protected void doNegativePosition() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        Position position = this.m_XYUi.getNegativePosition();
        String string = this.m_Chart.getType();
        PositionDialog positionDialog = new PositionDialog(elixirFrame.getFrame(), Messages.getString("XYTab.NEGATIVE_POSITION"), position, string, false);
        positionDialog.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(positionDialog);
        if (positionDialog.isOk()) {
            position = positionDialog.getPosition();
            this.m_XYUi.setNegativePosition(position);
            this.m_NegativeDescription.setText(this.describe(position));
        }
    }
}

