/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.command;

import com.elixirtech.command.Command;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommandManager {
    private List<Command> m_DoneStk = new ArrayList<Command>();
    private List<Command> m_UndoneStk = new ArrayList<Command>();
    private List<ChangeListener> m_ChangeListeners = new ArrayList<ChangeListener>();
    private ChangeEvent m_ChangeEvent = new ChangeEvent(this);

    public void addChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
    }

    public void clear() {
        this.m_DoneStk.clear();
        this.m_UndoneStk.clear();
        this.fireStateChanged();
    }

    public void doCommand(Command command) {
        command.doIt();
        this.m_DoneStk.add(command);
        this.m_UndoneStk.clear();
        this.fireStateChanged();
    }

    public void undo() {
        assert (this.canUndo());
        int n = this.m_DoneStk.size() - 1;
        Command command = this.m_DoneStk.get(n);
        command.undoIt();
        this.m_DoneStk.remove(n);
        this.m_UndoneStk.add(command);
        this.fireStateChanged();
    }

    public void redo() {
        assert (this.canRedo());
        int n = this.m_UndoneStk.size() - 1;
        Command command = this.m_UndoneStk.get(n);
        command.redoIt();
        try {
            this.m_UndoneStk.remove(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.m_DoneStk.add(command);
        this.fireStateChanged();
    }

    public boolean canUndo() {
        return this.m_DoneStk.size() > 0;
    }

    public boolean canRedo() {
        return this.m_UndoneStk.size() > 0;
    }

    private void fireStateChanged() {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
        arrayList.addAll(this.m_ChangeListeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(this.m_ChangeEvent);
        }
    }
}

