/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.connector;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.connector.A2021Connection;
import com.elixirtech.connector.ConnectionResult;
import com.elixirtech.connector.DesignerAuthToken$;
import com.elixirtech.connector.LocalConnection$;
import com.elixirtech.connector.RemoteConnectionInfo;
import com.elixirtech.connector.RemoteConnectionInfo$;
import com.elixirtech.connector.RemoteMode;
import com.elixirtech.connector.UserPassword$;
import com.elixirtech.remote.RemoteInterface$;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public abstract class AbstractLogon
extends JDialog
implements LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(AbstractLogon.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AbstractLogon.class.getDeclaredField("connectionResult$lzy1"));
    private volatile Object log$lzy1;
    private final Option serverValue;
    private final Option userValue;
    private final Option passwordValue;
    private volatile Object connectionResult$lzy1;
    private final AbstractLogon thisFrame;
    private final JTextField serverField;
    private final JTextField userField;
    private final JPasswordField passwordField;
    private final JTextField totpField;
    private final JTextField tokenField;
    private final List allFields;
    private final JButton connect;
    private final JButton disconnect;
    private final JButton cancel;
    private final JTabbedPane tabs;
    private final JPanel form;

    public AbstractLogon(Option<String> serverValue, Option<String> userValue, Option<String> passwordValue) {
        this.serverValue = serverValue;
        this.userValue = userValue;
        this.passwordValue = passwordValue;
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle(this.getThisTitle());
        this.thisFrame = this;
        this.serverField = new JTextField(20);
        this.userField = new JTextField(20);
        this.passwordField = new JPasswordField(20);
        this.totpField = new JTextField(20);
        this.tokenField = new JTextField(20);
        this.allFields = (List)new .colon.colon((Object)this.serverField(), (List)new .colon.colon((Object)this.userField(), (List)new .colon.colon((Object)this.passwordField(), (List)new .colon.colon((Object)this.totpField(), (List)new .colon.colon((Object)this.tokenField(), (List)Nil$.MODULE$)))));
        this.serverField().setText((String)serverValue.getOrElse(this::$init$$$anonfun$1));
        this.serverField().setEnabled(serverValue.isEmpty());
        userValue.foreach((Function1)(JProcedure1 & Serializable)s -> this.userField().setText((String)s));
        this.userField().setEnabled(userValue.isEmpty());
        passwordValue.foreach((Function1)(JProcedure1 & Serializable)s -> this.passwordField().setText((String)s));
        this.connect = new JButton(){
            {
                this.setDefaultCapable(true);
            }
        };
        this.disconnect = new JButton("Disconnect");
        this.cancel = new JButton("Cancel");
        ConnectionResult connectionResult = this.connectionResult();
        LocalConnection$ localConnection$ = LocalConnection$.MODULE$;
        if (!(connectionResult != null ? !connectionResult.equals(localConnection$) : localConnection$ != null)) {
            this.disconnect().setEnabled(false);
        }
        this.connect().addActionListener(new ActionListener(this){
            private final /* synthetic */ AbstractLogon $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.doConnect();
            }
        });
        this.disconnect().addActionListener(new ActionListener(this){
            private final /* synthetic */ AbstractLogon $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.doDisconnect();
            }
        });
        this.cancel().addActionListener(new ActionListener(this){
            private final /* synthetic */ AbstractLogon $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.dispose();
            }
        });
        this.tabs = this.buildTabs();
        this.form = this.buildForm();
        this.add((Component)this.form(), "Center");
        this.getRootPane().setDefaultButton(this.connect());
        this.pack();
        this.setLocationRelativeTo(null);
        Option option = this.allFields().find((Function1 & Serializable)_$1 -> _$1.getText().isEmpty());
        if (option instanceof Some) {
            JTextField field = (JTextField)((Some)option).value();
            field.requestFocus();
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<String> serverValue() {
        return this.serverValue;
    }

    public Option<String> userValue() {
        return this.userValue;
    }

    public Option<String> passwordValue() {
        return this.passwordValue;
    }

    public ConnectionResult connectionResult() {
        Object object = this.connectionResult$lzy1;
        if (object instanceof ConnectionResult) {
            return (ConnectionResult)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ConnectionResult)this.connectionResult$lzyINIT1();
    }

    private Object connectionResult$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.connectionResult$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ConnectionResult connectionResult = null;
                    try {
                        connectionResult = RemoteInterface$.MODULE$.getConnectionResult();
                        object2 = connectionResult == null ? LazyVals.NullValue$.MODULE$ : connectionResult;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.connectionResult$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return connectionResult;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AbstractLogon thisFrame() {
        return this.thisFrame;
    }

    public abstract Preferences prefs();

    public abstract void launch(RemoteConnectionInfo var1);

    public String getThisTitle() {
        ConnectionResult connectionResult = this.connectionResult();
        if (LocalConnection$.MODULE$.equals(connectionResult)) {
            return "Connect to Server";
        }
        if (connectionResult instanceof A2021Connection) {
            A2021Connection a = (A2021Connection)connectionResult;
            return "Connected to " + a.connectionInfo().requestedServer();
        }
        throw new MatchError((Object)connectionResult);
    }

    public JTextField serverField() {
        return this.serverField;
    }

    public JTextField userField() {
        return this.userField;
    }

    public JPasswordField passwordField() {
        return this.passwordField;
    }

    public JTextField totpField() {
        return this.totpField;
    }

    public JTextField tokenField() {
        return this.tokenField;
    }

    public List<JTextField> allFields() {
        return this.allFields;
    }

    public JButton connect() {
        return this.connect;
    }

    public JButton disconnect() {
        return this.disconnect;
    }

    public JButton cancel() {
        return this.cancel;
    }

    public JTabbedPane tabs() {
        return this.tabs;
    }

    public JPanel form() {
        return this.form;
    }

    public JPanel buildForm() {
        JPanel holder = new JPanel(new GridBagLayout());
        holder.setBorder(new EmptyBorder(10, 10, 2, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 0);
        int row = 0;
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        holder.add((Component)this.label("Server:"), c);
        c.gridx = 1;
        c.gridy = row++;
        holder.add((Component)this.serverField(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 2;
        holder.add((Component)this.tabs(), c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 2;
        holder.add((Component)this.buttons(), c);
        return holder;
    }

    public JPanel buttons() {
        JPanel holder = new JPanel(new FlowLayout());
        ((List)new .colon.colon((Object)this.connect(), (List)new .colon.colon((Object)this.disconnect(), (List)new .colon.colon((Object)this.cancel(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)x$0 -> holder.add((Component)x$0));
        return holder;
    }

    public JTabbedPane buildTabs() {
        JTabbedPane tabs = SwingFactory.newTabbedPane("tabs");
        tabs.addTab("with Password", this.form1());
        tabs.addTab("with Authentication Token", this.form2());
        return tabs;
    }

    public JPanel form1() {
        JPanel holder = new JPanel(new GridBagLayout());
        holder.setBorder(new EmptyBorder(10, 10, 2, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 0);
        int row = 0;
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        holder.add((Component)this.label("User Name:"), c);
        c.gridx = 1;
        c.gridy = row++;
        holder.add((Component)this.userField(), c);
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        holder.add((Component)this.label("Password:"), c);
        c.gridx = 1;
        c.gridy = row++;
        holder.add((Component)this.passwordField(), c);
        c.gridx = 0;
        c.gridy = row;
        holder.add((Component)this.label("2FA:"), c);
        c.gridx = 1;
        c.gridy = row++;
        holder.add((Component)this.totpField(), c);
        return holder;
    }

    public JPanel form2() {
        JPanel holder = new JPanel();
        holder.setBorder(new EmptyBorder(10, 10, 2, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 3, 3, 0);
        int row = 0;
        c.gridx = 0;
        c.gridy = row;
        c.gridwidth = 1;
        holder.add((Component)this.label("Token:"), c);
        c.gridx = 1;
        c.gridy = row++;
        holder.add((Component)this.tokenField(), c);
        return holder;
    }

    public JLabel label(String s) {
        JLabel ret = new JLabel(s);
        ret.setHorizontalAlignment(4);
        return ret;
    }

    public void doDisconnect() {
        RemoteInterface$.MODULE$.setConnectionResult(LocalConnection$.MODULE$);
        this.dispose();
    }

    public void doConnect() {
        this.allFields().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.setEnabled(false));
        this.connect().setEnabled(false);
        new ConnectThread().start();
    }

    private final String $init$$$anonfun$1() {
        return this.prefs().get("server", "");
    }

    public static final /* synthetic */ void com$elixirtech$connector$AbstractLogon$$anon$6$$_$run$$anonfun$1(JTextField _$3) {
        _$3.setEnabled(true);
    }

    public class ConnectThread
    extends Thread {
        private final String server;
        private final String user;
        private final String pass;
        private final String totp;
        private final String token;

        public ConnectThread() {
            if (AbstractLogon.this == null) {
                throw new NullPointerException();
            }
            super("Connect");
            this.server = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(AbstractLogon.this.serverField().getText().trim()), "/");
            this.user = AbstractLogon.this.userField().getText().trim();
            this.pass = new String(AbstractLogon.this.passwordField().getPassword());
            this.totp = AbstractLogon.this.totpField().getText().trim();
            this.token = AbstractLogon.this.tokenField().getText().trim();
        }

        public String server() {
            return this.server;
        }

        public String user() {
            return this.user;
        }

        public String pass() {
            return this.pass;
        }

        public String totp() {
            return this.totp;
        }

        public String token() {
            return this.token;
        }

        @Override
        public void run() {
            try {
                RemoteMode remoteMode = AbstractLogon.this.tabs().getSelectedIndex() == 0 ? UserPassword$.MODULE$.apply(this.user(), this.pass(), this.totp()) : DesignerAuthToken$.MODULE$.apply(this.token());
                RemoteConnectionInfo connInfo = RemoteConnectionInfo$.MODULE$.apply(this.server(), remoteMode);
                SwingUtilities.invokeLater(new Runnable(connInfo, this){
                    private final RemoteConnectionInfo connInfo$1;
                    private final /* synthetic */ ConnectThread $outer;
                    {
                        this.connInfo$1 = connInfo$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void run() {
                        this.$outer.com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer().thisFrame().dispose();
                        this.$outer.com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer().launch(this.connInfo$1);
                        this.$outer.com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer().prefs().put("server", this.$outer.server());
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(ex, this){
                    private final Exception ex$1;
                    private final /* synthetic */ ConnectThread $outer;
                    {
                        this.ex$1 = ex$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void run() {
                        String msg = this.ex$1.getMessage();
                        JOptionPane.showMessageDialog(this.$outer.com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer().connect(), "Unable to connect: " + msg, "Logon Error", 0);
                        this.$outer.com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer().allFields().foreach((Function1)((JProcedure1 & Serializable)AbstractLogon::com$elixirtech$connector$AbstractLogon$$anon$6$$_$run$$anonfun$1));
                        this.$outer.com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer().connect().setEnabled(true);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$elixirtech$connector$AbstractLogon$$anon$6$$_$run$$anonfun$1(javax.swing.JTextField )}, serializedLambda);
                    }
                });
            }
        }

        public final /* synthetic */ AbstractLogon com$elixirtech$connector$AbstractLogon$ConnectThread$$$outer() {
            return AbstractLogon.this;
        }
    }
}

