/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.connector;

import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.GUIClientRequest$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.connector.A2021Connection$;
import com.elixirtech.connector.AbstractLogon;
import com.elixirtech.connector.ConnectionDialog$;
import com.elixirtech.connector.ConnectionDialog$A2021Response$;
import com.elixirtech.connector.ConnectionResult;
import com.elixirtech.connector.DesignerAuthToken;
import com.elixirtech.connector.RemoteConnectionInfo;
import com.elixirtech.connector.RemoteMode;
import com.elixirtech.connector.RepertoireGUI;
import com.elixirtech.connector.UserPassword;
import com.elixirtech.guiapi.ambience.Email$;
import com.elixirtech.guiapi.ambience.Privileges$;
import com.elixirtech.guiapi.ambience.Roles$;
import com.elixirtech.guiapi.ambience.Server$;
import com.elixirtech.guiapi.ambience.UserId$;
import com.elixirtech.guiapi.ambience.UserInfo;
import com.elixirtech.guiapi.ambience.UserInfo$;
import com.elixirtech.guiapi.ambience.Username$;
import com.elixirtech.remote.RemoteInterface$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.UUID;
import java.util.prefs.Preferences;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple7$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ConnectionDialog
extends AbstractLogon {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConnectionDialog.class.getDeclaredField("prefs$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConnectionDialog.class.getDeclaredField("bannerSize$lzy1"));
    private final Scheduler exeCxt = Scheduler$.MODULE$.global();
    private volatile Object bannerSize$lzy1;
    private volatile Object prefs$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ConnectionDialog$.class.getDeclaredField("log$lzy1"));

    public ConnectionDialog() {
        super((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public Dimension bannerSize() {
        Object object = this.bannerSize$lzy1;
        if (object instanceof Dimension) {
            return (Dimension)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Dimension)this.bannerSize$lzyINIT1();
    }

    private Object bannerSize$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.bannerSize$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Dimension dimension = null;
                    try {
                        dimension = new Dimension(50, 50);
                        object2 = dimension == null ? LazyVals.NullValue$.MODULE$ : dimension;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bannerSize$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dimension;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Preferences prefs() {
        Object object = this.prefs$lzy1;
        if (object instanceof Preferences) {
            return (Preferences)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Preferences)this.prefs$lzyINIT1();
    }

    private Object prefs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.prefs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Preferences preferences = null;
                    try {
                        preferences = Preferences.userNodeForPackage(RepertoireGUI.class);
                        object2 = preferences == null ? LazyVals.NullValue$.MODULE$ : preferences;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.prefs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return preferences;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void launch(RemoteConnectionInfo connInfo) {
        Option<ConnectionResult> option = this.tryA2021(connInfo);
        if (option instanceof Some) {
            ConnectionResult cr = (ConnectionResult)((Some)option).value();
            this.log().info(() -> ConnectionDialog.launch$$anonfun$1(cr), Line$.MODULE$.apply(49), FullName$.MODULE$.apply("com.elixirtech.connector.ConnectionDialog.launch"));
            RemoteInterface$.MODULE$.setConnectionResult(cr);
            this.dispose();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Option<ConnectionResult> tryA2021(RemoteConnectionInfo connInfo) {
        None$ none$;
        block7: {
            Map<String, String> body = this.buildBody(connInfo);
            try {
                HttpClientResponse response = GUIClientRequest$.MODULE$.post(this.buildLoginURL(connInfo), body, GUIClientRequest$.MODULE$.post$default$3());
                this.log().info(() -> ConnectionDialog.tryA2021$$anonfun$1(response), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("com.elixirtech.connector.ConnectionDialog.tryA2021"));
                if (response.statusCode() != 200) {
                    this.log().warn(() -> ConnectionDialog.tryA2021$$anonfun$2(response), Line$.MODULE$.apply(62), FullName$.MODULE$.apply("com.elixirtech.connector.ConnectionDialog.tryA2021"));
                    if (response.statusCode() == 403) {
                        ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error("Invalid credentials");
                    } else {
                        ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error("Cannot connect to server");
                    }
                    none$ = None$.MODULE$;
                    break block7;
                }
                String string = "id";
                String string2 = "username";
                String string3 = "email";
                String string4 = "roles";
                String string5 = "privileges";
                String string6 = "cookieName";
                String string7 = "cookieValue";
                int size = 7;
                Either either = io.circe.parser.package$.MODULE$.decode(new String(response.body(), "UTF-8"), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("A2021Response", ConnectionDialog::tryA2021$$anonfun$3, package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ConnectionDialog::tryA2021$$anonfun$4, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ConnectionDialog::tryA2021$$anonfun$5)))));
                if (either instanceof Right) {
                    A2021Response resp = (A2021Response)((Right)either).value();
                    this.log().info(() -> ConnectionDialog.tryA2021$$anonfun$6(resp), Line$.MODULE$.apply(70), FullName$.MODULE$.apply("com.elixirtech.connector.ConnectionDialog.tryA2021"));
                    none$ = Some$.MODULE$.apply((Object)A2021Connection$.MODULE$.apply(connInfo, "A2020+", this.asUserInfo(connInfo.requestedServer(), resp)));
                    break block7;
                }
                if (either instanceof Left) {
                    Error err = (Error)((Left)either).value();
                    this.log().warn(() -> ConnectionDialog.tryA2021$$anonfun$7(err), Line$.MODULE$.apply(73), FullName$.MODULE$.apply("com.elixirtech.connector.ConnectionDialog.tryA2021"));
                    ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error("Invalid server response");
                    none$ = None$.MODULE$;
                    break block7;
                }
                throw new MatchError((Object)either);
            }
            catch (Throwable ex) {
                this.log().error(() -> ConnectionDialog.tryA2021$$anonfun$8(ex), Line$.MODULE$.apply(81), FullName$.MODULE$.apply("com.elixirtech.connector.ConnectionDialog.tryA2021"));
                ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error("Unable to connect to server");
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public UserInfo asUserInfo(String server, A2021Response response) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)response.cookieName());
        return UserInfo$.MODULE$.apply(Server$.MODULE$.apply(server), UserId$.MODULE$.apply(response.id()), Username$.MODULE$.apply(response.username()), Email$.MODULE$.apply(response.email()), Roles$.MODULE$.apply(response.roles()), Privileges$.MODULE$.apply(response.privileges()), (Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)response.cookieValue()));
    }

    public Map<String, String> buildBody(RemoteConnectionInfo connInfo) {
        RemoteMode remoteMode = connInfo.remoteMode();
        if (remoteMode instanceof UserPassword) {
            UserPassword up = (UserPassword)remoteMode;
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"username");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)up.userName());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"password");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)up.password());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"totp");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)up.totp());
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (remoteMode instanceof DesignerAuthToken) {
            DesignerAuthToken at = (DesignerAuthToken)remoteMode;
            Tuple2<String, String> tuple2 = this.buildToken(at);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String token = (String)tuple2._1();
            String code = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)token, (Object)code);
            String token2 = (String)tuple22._1();
            String code2 = (String)tuple22._2();
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"token");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)token2);
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"code");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)code2);
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        throw new MatchError((Object)remoteMode);
    }

    public Tuple2<String, String> buildToken(DesignerAuthToken at) {
        String code = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 8);
        String token = Crypt$.MODULE$.encrypt(code + at.value());
        return Tuple2$.MODULE$.apply((Object)token, (Object)code);
    }

    public String buildLoginURL(RemoteConnectionInfo connInfo) {
        RemoteMode remoteMode = connInfo.remoteMode();
        if (remoteMode instanceof UserPassword) {
            UserPassword up = (UserPassword)remoteMode;
            return connInfo.requestedServer() + "/remote-access/login";
        }
        if (remoteMode instanceof DesignerAuthToken) {
            DesignerAuthToken at = (DesignerAuthToken)remoteMode;
            return connInfo.requestedServer() + "/designer-integration/submit-token";
        }
        throw new MatchError((Object)remoteMode);
    }

    private static final Object launch$$anonfun$1(ConnectionResult cr$1) {
        return "Connected to " + cr$1.name();
    }

    private static final Object tryA2021$$anonfun$1(HttpClientResponse response$1) {
        return "tryA2021 " + response$1.statusCode();
    }

    private static final Object tryA2021$$anonfun$2(HttpClientResponse response$2) {
        return "tryA2021: " + new String(response$2.body(), "UTF-8");
    }

    private static final List tryA2021$$anonfun$3() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        Decoder decodeA7;
        DecoderNotDeriveSum f$proxy1;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy1 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA7 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA6 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy1;
        Configuration x$2$proxy4 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA4 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy1;
        Configuration x$2$proxy5 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA3 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        DecoderNotDeriveSum DecoderNotDeriveSum_this6 = f$proxy1;
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this6.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder6 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this7 = f$proxy1;
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this7.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder7 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder7).$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 tryA2021$$anonfun$4() {
        ConnectionDialog$A2021Response$ connectionDialog$A2021Response$ = ConnectionDialog$A2021Response$.MODULE$;
        return (Function1 & Serializable)p -> (A2021Response)connectionDialog$A2021Response$.fromProduct((Product)p);
    }

    private static final Product tryA2021$$anonfun$5() {
        return Tuple7$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object tryA2021$$anonfun$6(A2021Response resp$1) {
        return "tryA2021 success name=" + resp$1.username() + " (" + resp$1.email() + ")";
    }

    private static final Object tryA2021$$anonfun$7(Error err$1) {
        return "tryA2021 failed: " + err$1;
    }

    private static final Object tryA2021$$anonfun$8(Throwable ex$1) {
        return "Unable to connect to server: " + ex$1;
    }

    public static final class A2021Response
    implements Product,
    Serializable {
        private final String id;
        private final String username;
        private final String email;
        private final Set roles;
        private final Set privileges;
        private final String cookieName;
        private final String cookieValue;

        public static A2021Response apply(String string, String string2, String string3, Set<String> set, Set<String> set2, String string4, String string5) {
            return ConnectionDialog$A2021Response$.MODULE$.apply(string, string2, string3, set, set2, string4, string5);
        }

        public static A2021Response fromProduct(Product product) {
            return ConnectionDialog$A2021Response$.MODULE$.fromProduct(product);
        }

        public static A2021Response unapply(A2021Response a2021Response) {
            return ConnectionDialog$A2021Response$.MODULE$.unapply(a2021Response);
        }

        public A2021Response(String id, String username, String email, Set<String> roles, Set<String> privileges, String cookieName, String cookieValue) {
            this.id = id;
            this.username = username;
            this.email = email;
            this.roles = roles;
            this.privileges = privileges;
            this.cookieName = cookieName;
            this.cookieValue = cookieValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof A2021Response)) return false;
            A2021Response a2021Response = (A2021Response)object;
            String string = this.id();
            String string2 = a2021Response.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.username();
            String string4 = a2021Response.username();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.email();
            String string6 = a2021Response.email();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Set<String> set = this.roles();
            Set<String> set2 = a2021Response.roles();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<String> set3 = this.privileges();
            Set<String> set4 = a2021Response.privileges();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            String string7 = this.cookieName();
            String string8 = a2021Response.cookieName();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.cookieValue();
            String string10 = a2021Response.cookieValue();
            if (string9 == null) {
                if (string10 == null) return true;
                return false;
            } else {
                if (!string9.equals(string10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof A2021Response;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "A2021Response";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "username";
                }
                case 2: {
                    return "email";
                }
                case 3: {
                    return "roles";
                }
                case 4: {
                    return "privileges";
                }
                case 5: {
                    return "cookieName";
                }
                case 6: {
                    return "cookieValue";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String username() {
            return this.username;
        }

        public String email() {
            return this.email;
        }

        public Set<String> roles() {
            return this.roles;
        }

        public Set<String> privileges() {
            return this.privileges;
        }

        public String cookieName() {
            return this.cookieName;
        }

        public String cookieValue() {
            return this.cookieValue;
        }

        public A2021Response copy(String id, String username, String email, Set<String> roles, Set<String> privileges, String cookieName, String cookieValue) {
            return new A2021Response(id, username, email, roles, privileges, cookieName, cookieValue);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.username();
        }

        public String copy$default$3() {
            return this.email();
        }

        public Set<String> copy$default$4() {
            return this.roles();
        }

        public Set<String> copy$default$5() {
            return this.privileges();
        }

        public String copy$default$6() {
            return this.cookieName();
        }

        public String copy$default$7() {
            return this.cookieValue();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.username();
        }

        public String _3() {
            return this.email();
        }

        public Set<String> _4() {
            return this.roles();
        }

        public Set<String> _5() {
            return this.privileges();
        }

        public String _6() {
            return this.cookieName();
        }

        public String _7() {
            return this.cookieValue();
        }
    }
}

