/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.attributes.ui.CommentsPanel;
import com.elixirtech.data2.attributes.ui.EnumerationPanel;
import com.elixirtech.data2.attributes.ui.ForeignKeyPanel;
import com.elixirtech.data2.attributes.ui.FormatPanel;
import com.elixirtech.data2.attributes.ui.IDataAttributePanel;
import com.elixirtech.data2.attributes.ui.NullablePanel;
import com.elixirtech.data2.attributes.ui.PrimaryKeyPanel;
import com.elixirtech.data2.attributes.ui.RangePanel;
import com.elixirtech.data2.attributes.ui.RegExpPanel;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataAttributeDialog
extends EscapableDialog
implements ActionListener,
ItemListener {
    private IDataAttributePanel[] m_Panels;
    private JComboBox m_Type;
    private JPanel m_Cards;
    private CardLayout m_CardLayout;
    private JButton m_Ok;
    private boolean m_IsOk;
    private boolean m_ReadOnly;

    public DataAttributeDialog(JDialog jDialog, DataAttribute dataAttribute, boolean bl) {
        super(jDialog);
        this.m_ReadOnly = bl;
        this.init(dataAttribute);
    }

    public DataAttributeDialog(JFrame jFrame, DataAttribute dataAttribute, boolean bl) {
        super(jFrame);
        this.m_ReadOnly = bl;
        this.init(dataAttribute);
    }

    protected void init(DataAttribute dataAttribute) {
        this.setTitle(I18N.ENSEMBLE.getString("DataAttributeDialog.TITLE"));
        this.setModal(true);
        this.m_Panels = new IDataAttributePanel[]{new CommentsPanel(), new EnumerationPanel(), new ForeignKeyPanel(), new FormatPanel(), new NullablePanel(), new PrimaryKeyPanel(), new RangePanel(), new RegExpPanel()};
        this.buildUI();
        if (dataAttribute != null) {
            String string = dataAttribute.getName();
            this.m_Type.setSelectedItem(string);
            this.m_Type.setEnabled(false);
            IDataAttributePanel iDataAttributePanel = this.getPanel(string);
            if (iDataAttributePanel != null) {
                iDataAttributePanel.setAttribute(dataAttribute);
            }
        }
        this.checkEnabled();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    public DataAttribute getDataAttribute() {
        int n = this.m_Type.getSelectedIndex();
        return this.m_Panels[n].getAttribute();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok".equals(string)) {
            this.m_IsOk = true;
            this.dispose();
        } else if ("cancel".equals(string)) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.m_Type.getSelectedItem();
        this.m_CardLayout.show(this.m_Cards, string);
        this.checkEnabled();
    }

    protected void checkEnabled() {
        int n = this.m_Type.getSelectedIndex();
        this.m_Ok.setEnabled(!this.m_ReadOnly && !this.m_Panels[n].getType().equals("ForeignKey"));
    }

    protected void buildUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add(new JLabel(I18N.ENSEMBLE.getString("DataAttributeDialog.Type")));
        String[] stringArray = new String[this.m_Panels.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_Panels[i].getType();
        }
        this.m_Type = new JComboBox<String>(stringArray);
        this.m_Type.addItemListener(this);
        jPanel.add(this.m_Type);
        container.add((Component)jPanel, "North");
        this.m_CardLayout = new CardLayout();
        this.m_Cards = new JPanel(this.m_CardLayout);
        this.m_Cards.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        for (IDataAttributePanel iDataAttributePanel : this.m_Panels) {
            this.m_Cards.add(iDataAttributePanel.getType(), iDataAttributePanel.getComponent());
        }
        container.add((Component)this.m_Cards, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.m_Ok = SwingFactory.newOkButton(this);
        this.m_Ok.setActionCommand("ok");
        JButton jButton = SwingFactory.newCancelButton(this);
        jButton.setActionCommand("cancel");
        jPanel2.add(this.m_Ok);
        jPanel2.add(jButton);
        container.add((Component)jPanel2, "South");
        this.pack();
    }

    protected IDataAttributePanel getPanel(String string) {
        for (IDataAttributePanel iDataAttributePanel : this.m_Panels) {
            if (!string.equals(iDataAttributePanel.getType())) continue;
            return iDataAttributePanel;
        }
        return null;
    }
}

