/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.attributes.ui.DataAttributesDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.BasicTableEditor;
import com.elixirtech.util.StrBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;

public class DataAttributesEditor
extends BasicTableEditor
implements ActionListener {
    private JPanel m_Panel;
    private JLabel m_Label;
    private JButton m_Dots;
    private DataAttributes m_Attributes;
    private boolean m_ReadOnly;

    public DataAttributesEditor(boolean bl) {
        this.m_ReadOnly = bl;
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_Panel.setOpaque(true);
        this.m_Label = new JLabel("");
        this.m_Label.setOpaque(false);
        this.m_Label.setFont(UIManager.getFont("TextField.font"));
        this.m_Dots = SwingFactory.newDotsButton(this);
        this.m_Dots.setBorder(null);
        this.m_Panel.add((Component)this.m_Label, "Center");
        this.m_Panel.add((Component)this.m_Dots, "East");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.m_Panel.setOpaque(true);
        this.m_Label.setOpaque(false);
        this.setLabel((DataAttributes)object);
        if (bl) {
            Color color = jTable.getSelectionBackground();
            Color color2 = jTable.getSelectionForeground();
            this.m_Panel.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
            this.m_Label.setForeground(new Color(color2.getRed(), color2.getGreen(), color2.getBlue()));
        } else {
            Color color = jTable.getBackground();
            Color color3 = jTable.getForeground();
            if (n % 2 == 0) {
                color = UIManager.getColor("Table.alternateRowColor");
            }
            this.m_Panel.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
            this.m_Label.setForeground(new Color(color3.getRed(), color3.getGreen(), color3.getBlue()));
        }
        return this.m_Panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getTableCellRendererComponent(jTable, object, true, true, n, n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        DataAttributesDialog dataAttributesDialog = new DataAttributesDialog(elixirFrame.getFrame(), this.m_Attributes, this.m_ReadOnly);
        dataAttributesDialog.setLocationRelativeTo(this.m_Panel);
        elixirFrame.showModal(dataAttributesDialog);
        if (dataAttributesDialog.isOk()) {
            this.m_Attributes = dataAttributesDialog.getDataAttributes();
        }
        this.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_Attributes;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    protected void setLabel(DataAttributes dataAttributes) {
        this.m_Attributes = dataAttributes;
        StrBuffer strBuffer = new StrBuffer();
        if (this.m_Attributes != null) {
            List list = this.m_Attributes.getAttributes();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DataAttribute dataAttribute = (DataAttribute)iterator.next();
                strBuffer.append(dataAttribute.getRenderableName());
                if (!iterator.hasNext()) continue;
                strBuffer.append(", ");
            }
        }
        this.m_Label.setText(strBuffer.toString());
    }
}

