/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.attributes.ui.DataAttributeDialog;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.ui.EditableList;
import com.elixirtech.ui.LCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class DataAttributesPanel
extends JPanel
implements ActionListener {
    private JDialog m_Parent;
    private EditableList m_Table;
    private DAModel m_Model;
    private boolean m_ReadOnly;

    public DataAttributesPanel(JDialog jDialog, DataAttributes dataAttributes, boolean bl) {
        this.m_Parent = jDialog;
        this.m_ReadOnly = bl;
        this.m_Model = new DAModel(dataAttributes);
        this.m_Table = new DAEditableList(this.m_Model);
        this.m_Table.setEnabled(!this.m_ReadOnly);
        this.m_Table.addActionListener(this);
        this.m_Table.setCellRenderer(new LCellRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Table, "Center");
        this.setPreferredSize(new Dimension(300, 200));
    }

    public DataAttributes getDataAttributes() {
        int n = this.m_Model.getSize();
        DataAttributes dataAttributes = new DataAttributes();
        for (int i = 0; i < n; ++i) {
            dataAttributes.addAttribute((DataAttribute)this.m_Model.get(i));
        }
        return dataAttributes;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            DataAttributeDialog dataAttributeDialog = new DataAttributeDialog(this.m_Parent, null, this.m_ReadOnly);
            dataAttributeDialog.setLocationRelativeTo(this);
            elixirFrame.showModal(dataAttributeDialog);
            if (dataAttributeDialog.isOk()) {
                DataAttribute dataAttribute = dataAttributeDialog.getDataAttribute();
                DataAttribute dataAttribute2 = this.getConflict(dataAttribute);
                if (dataAttribute2 != null) {
                    int n = JOptionPane.showConfirmDialog(elixirFrame.getFrame(), I18NUtil.getString(I18N.ENSEMBLE, "DataAttributesPanel.ConflictMessage", dataAttribute2.getRenderableName()), I18N.ENSEMBLE.getString("DataAttributesPanel.Conflict"), 0);
                    if (n == 0) {
                        int n2 = this.m_Model.indexOf(dataAttribute2);
                        this.m_Model.set(n2, dataAttribute);
                    }
                } else {
                    this.m_Model.addElement(dataAttribute);
                }
            }
        } else if ("minus".equals(string)) {
            int[] nArray = this.m_Table.getSelectedRows();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.m_Model.remove(nArray[i]);
            }
        } else if ("edit".equals(string)) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            int n = this.m_Table.getSelectedRow();
            DataAttribute dataAttribute = (DataAttribute)this.m_Model.get(n);
            DataAttributeDialog dataAttributeDialog = new DataAttributeDialog(this.m_Parent, dataAttribute, this.m_ReadOnly);
            dataAttributeDialog.setLocationRelativeTo(this);
            elixirFrame.showModal(dataAttributeDialog);
            if (dataAttributeDialog.isOk()) {
                DataAttribute dataAttribute3 = dataAttributeDialog.getDataAttribute();
                this.m_Model.set(n, dataAttribute3);
            }
        }
    }

    private DataAttribute getConflict(DataAttribute dataAttribute) {
        String string = dataAttribute.getName();
        int n = this.m_Model.getSize();
        for (int i = 0; i < n; ++i) {
            DataAttribute dataAttribute2 = (DataAttribute)this.m_Model.get(i);
            if (!string.equals(dataAttribute2.getName())) continue;
            return dataAttribute2;
        }
        return null;
    }

    private class DAModel
    extends DefaultListModel {
        public DAModel(DataAttributes dataAttributes) {
            if (dataAttributes != null) {
                for (DataAttribute dataAttribute : dataAttributes.getAttributes()) {
                    this.addElement(dataAttribute);
                }
            }
        }
    }

    private class DAEditableList
    extends EditableList {
        public DAEditableList(ListModel listModel) {
            super(listModel, false);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.checkEnabled();
        }

        @Override
        public void checkEnabled() {
            boolean bl = !DataAttributesPanel.this.m_ReadOnly;
            int n = this.m_List.getSelectedIndex();
            this.m_Plus.setEnabled(bl);
            this.m_Edit.setEnabled(n >= 0 && this.m_List.getSelectedIndices().length == 1);
            this.m_Edit.setToolTipText(bl ? I18N.ENSEMBLE.getString("DataAttributesPanel.Edit") : I18N.ENSEMBLE.getString("DataAttributesPanel.View"));
            this.m_Minus.setEnabled(bl && n >= 0 && this.m_List.getModel().getSize() > this.m_MinRows);
        }
    }
}

