/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.attributes.Enumeration;
import com.elixirtech.data2.attributes.ui.IDataAttributePanel;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EnumerationPanel
implements IDataAttributePanel {
    private JPanel m_Panel;
    private JTextArea m_EnumerationText;
    private JRadioButton m_Nominal;
    private JRadioButton m_Ordinal;

    public EnumerationPanel() {
        this.buildUI();
    }

    @Override
    public String getType() {
        return "Enumeration";
    }

    @Override
    public JComponent getComponent() {
        return this.m_Panel;
    }

    @Override
    public void setAttribute(DataAttribute dataAttribute) {
        String string = StringUtil.concat((Collection<String>)((Enumeration)dataAttribute).getChoices(), '\n');
        this.m_EnumerationText.setText(string);
        String string2 = ((Enumeration)dataAttribute).getType();
        if ("Nominal".equals(string2)) {
            this.m_Nominal.setSelected(true);
        } else {
            this.m_Ordinal.setSelected(true);
        }
    }

    @Override
    public DataAttribute getAttribute() {
        if (this.m_Nominal.isSelected()) {
            return Enumeration.newNominal(this.getChoices(this.m_EnumerationText));
        }
        return Enumeration.newOrdinal(this.getChoices(this.m_EnumerationText));
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_Nominal.setEnabled(bl);
        this.m_Ordinal.setEnabled(bl);
        this.m_EnumerationText.setEditable(bl);
    }

    protected void buildUI() {
        this.m_Panel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(new JLabel(I18N.ENSEMBLE.getString("EnumerationPanel.OnePerLine")));
        JPanel jPanel2 = new JPanel();
        this.m_Nominal = new JRadioButton(I18N.ENSEMBLE.getString("EnumerationPanel.Nominal"));
        this.m_Ordinal = new JRadioButton(I18N.ENSEMBLE.getString("EnumerationPanel.Ordinal"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Nominal);
        buttonGroup.add(this.m_Ordinal);
        this.m_Nominal.setSelected(true);
        jPanel2.add(this.m_Nominal);
        jPanel2.add(this.m_Ordinal);
        jPanel.add(jPanel2);
        this.m_Panel.add((Component)jPanel, "North");
        this.m_EnumerationText = new JTextArea(10, 30);
        this.m_EnumerationText.setLineWrap(false);
        this.m_Panel.add(new JScrollPane(this.m_EnumerationText));
    }

    protected List<String> getChoices(JTextArea jTextArea) {
        return StringUtil.listOfSubstrings(jTextArea.getText(), '\n');
    }
}

