/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.attributes.ForeignKey;
import com.elixirtech.data2.attributes.ui.IDataAttributePanel;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.LabelledPanel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ForeignKeyPanel
implements IDataAttributePanel {
    private LabelledPanel m_Panel;
    private JTextField m_FKeyTable;
    private JTextField m_FKeyColumn;
    private JTextField m_FKeySequence;

    public ForeignKeyPanel() {
        this.buildUI();
    }

    @Override
    public String getType() {
        return "ForeignKey";
    }

    @Override
    public JComponent getComponent() {
        return this.m_Panel;
    }

    @Override
    public void setAttribute(DataAttribute dataAttribute) {
        ForeignKey foreignKey = (ForeignKey)dataAttribute;
        this.m_FKeyTable.setText(foreignKey.getTable());
        this.m_FKeyColumn.setText(foreignKey.getColumn());
        this.m_FKeySequence.setText(String.valueOf(foreignKey.getSequence()));
    }

    @Override
    public DataAttribute getAttribute() {
        int n = 0;
        try {
            n = Integer.parseInt(this.m_FKeySequence.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ForeignKey(this.m_FKeyTable.getText(), this.m_FKeyColumn.getText(), n);
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    protected void buildUI() {
        this.m_Panel = new LabelledPanel();
        this.m_FKeyTable = new JTextField();
        this.m_FKeyColumn = new JTextField();
        this.m_FKeySequence = new JTextField();
        JLabel jLabel = new JLabel(I18N.ENSEMBLE.getString("ForeignKeyPanel.NotEditable"));
        this.m_Panel.addItem("table", new JLabel(I18N.ENSEMBLE.getString("ForeignKeyPanel.Table")), this.m_FKeyTable);
        this.m_Panel.addItem("column", new JLabel(I18N.ENSEMBLE.getString("ForeignKeyPanel.Column")), this.m_FKeyColumn);
        this.m_Panel.addItem("sequence", new JLabel(I18N.ENSEMBLE.getString("ForeignKeyPanel.Sequence")), this.m_FKeySequence);
        this.m_Panel.addItem("note", new JLabel(I18N.ENSEMBLE.getString("ForeignKeyPanel.Note")), jLabel);
        this.m_Panel.doLayout();
        this.m_FKeyTable.setEditable(false);
        this.m_FKeyColumn.setEditable(false);
        this.m_FKeySequence.setEditable(false);
    }
}

