/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.attributes.Range;
import com.elixirtech.data2.attributes.ui.IDataAttributePanel;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.LabelledPanel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RangePanel
implements IDataAttributePanel {
    private LabelledPanel m_Panel;
    private JTextField m_Start;
    private JTextField m_Stop;

    public RangePanel() {
        this.buildUI();
    }

    @Override
    public String getType() {
        return "Range";
    }

    @Override
    public JComponent getComponent() {
        return this.m_Panel;
    }

    @Override
    public void setAttribute(DataAttribute dataAttribute) {
        Range range = (Range)dataAttribute;
        this.m_Start.setText(range.getStart());
        this.m_Stop.setText(range.getStop());
    }

    @Override
    public DataAttribute getAttribute() {
        return new Range(this.m_Start.getText(), this.m_Stop.getText());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_Start.setEditable(bl);
        this.m_Stop.setEditable(bl);
    }

    protected void buildUI() {
        this.m_Panel = new LabelledPanel();
        this.m_Start = new JTextField();
        this.m_Stop = new JTextField();
        this.m_Panel.addItem("start", new JLabel(I18N.ENSEMBLE.getString("RangePanel.Start")), this.m_Start);
        this.m_Panel.addItem("end", new JLabel(I18N.ENSEMBLE.getString("RangePanel.End")), this.m_Stop);
        this.m_Panel.doLayout();
    }
}

