/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.util.FileUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class RegExpCatalog {
    private static final String FILENAME = "regexp-catalog.xml";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RegExpCatalog.class);
    private static final Map<String, String> STANDARD_REGEXPS = new TreeMap<String, String>();

    private static InputStream getConfigStream() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream("config/regexp-catalog.xml");
    }

    public static Map<String, String> getStandardRegExps() {
        return Collections.unmodifiableMap(STANDARD_REGEXPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = null;
        try {
            inputStream = RegExpCatalog.getConfigStream();
            if (inputStream != null) {
                SAXBuilder sAXBuilder = new SAXBuilder();
                Document document = sAXBuilder.build(inputStream);
                Element element = document.getRootElement();
                for (Element element2 : element.getChildren("regexp")) {
                    String string = element2.getAttributeValue("name");
                    String string2 = element2.getTextTrim();
                    STANDARD_REGEXPS.put(string, string2);
                }
            }
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Can't load standard regexps: " + String.valueOf(throwable)), throwable);
        }
        finally {
            FileUtil.close(inputStream);
        }
    }
}

