/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.attributes.RegExp;
import com.elixirtech.data2.attributes.ui.IDataAttributePanel;
import com.elixirtech.data2.attributes.ui.RegExpCatalog;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.SwingFactory;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RegExpPanel
implements IDataAttributePanel {
    private ArchLayout m_Layout;
    private JPanel m_Panel;
    private JTextField m_RegExpText;
    private JLabel m_RegExpSyntaxCheck;
    private JComboBox m_Catalog;
    private JTextField m_RegExpTestField;
    private JLabel m_PassFail;
    private boolean m_InUpdate;
    private static final String SYNTAX_PREFIX = I18N.ENSEMBLE.getString("RegExpPanel.Syntax");
    private static final String PASS = I18N.ENSEMBLE.getString("RegExpPanel.Pass");
    private static final String FAIL = I18N.ENSEMBLE.getString("RegExpPanel.Fail");

    public RegExpPanel() {
        this.buildUI();
        this.layoutContainer();
    }

    @Override
    public String getType() {
        return "RegExp";
    }

    @Override
    public JComponent getComponent() {
        return this.m_Panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(DataAttribute dataAttribute) {
        RegExp regExp = (RegExp)dataAttribute;
        String string = regExp.getExpression();
        if (string != null) {
            this.m_RegExpText.setText(string);
            this.m_InUpdate = true;
            try {
                Map<String, String> map = RegExpCatalog.getStandardRegExps();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!string.equals(entry.getValue())) continue;
                    this.m_Catalog.setSelectedItem(entry.getKey());
                    break;
                }
            }
            finally {
                this.m_InUpdate = false;
            }
        }
    }

    @Override
    public DataAttribute getAttribute() {
        return new RegExp(this.m_RegExpText.getText());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_RegExpText.setEditable(bl);
        this.m_Catalog.setEnabled(bl);
    }

    protected void buildUI() {
        this.m_Layout = new ArchLayout();
        this.m_Panel = new JPanel(this.m_Layout);
        this.m_Panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_RegExpText = new JTextField();
        this.m_RegExpText.getDocument().addDocumentListener(new RegExpDL());
        this.m_Panel.add("regexp", this.m_RegExpText);
        this.m_RegExpSyntaxCheck = new JLabel(SYNTAX_PREFIX);
        this.m_Panel.add("syntax", this.m_RegExpSyntaxCheck);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("");
        Map<String, String> map = RegExpCatalog.getStandardRegExps();
        for (String string : map.keySet()) {
            defaultComboBoxModel.addElement(string);
        }
        this.m_Panel.add("catalog-label", new JLabel(I18N.ENSEMBLE.getString("RegExpPanel.OrChooseFrom")));
        this.m_Catalog = SwingFactory.newComboBox("catalog", defaultComboBoxModel);
        this.m_Catalog.addItemListener(new CatalogChoiceListener());
        this.m_Panel.add(this.m_Catalog);
        this.m_RegExpTestField = new JTextField();
        this.m_RegExpTestField.getDocument().addDocumentListener(new RegExpDL());
        this.m_Panel.add("test-label", new JLabel(I18N.ENSEMBLE.getString("RegExpPanel.TestHere")));
        this.m_Panel.add("test", this.m_RegExpTestField);
        this.m_PassFail = new JLabel(PASS);
        Dimension dimension = this.m_PassFail.getPreferredSize();
        dimension.width += 10;
        this.m_PassFail.setPreferredSize(dimension);
        this.m_Panel.add("passfail", this.m_PassFail);
    }

    private void layoutContainer() {
        this.m_Layout.stickTop("regexp");
        this.m_Layout.stickLeft("regexp");
        this.m_Layout.stickRight("regexp");
        this.m_Layout.alignBelow("syntax", "regexp", 5);
        this.m_Layout.stickRight("syntax");
        this.m_Layout.stickLeft("catalog-label");
        this.m_Layout.putBelow("catalog", "syntax", 10);
        this.m_Layout.vCenter("catalog-label", "catalog");
        this.m_Layout.putRight("catalog", "catalog-label", 10);
        this.m_Layout.stickRight("catalog");
        this.m_Layout.putBelow("test", "catalog", 20);
        this.m_Layout.putRight("test", "test-label", 10);
        this.m_Layout.stickRight("passfail");
        this.m_Layout.vCenter("passfail", "test");
        this.m_Layout.putLeft("test", "passfail", -5);
        this.m_Layout.stickLeft("test-label");
        this.m_Layout.vCenter("test-label", "test");
    }

    public void updateTest() {
        try {
            this.m_PassFail.setText("");
            String string = this.m_RegExpText.getText();
            String string2 = this.m_RegExpTestField.getText();
            if (string.trim().length() > 0) {
                Pattern pattern = Pattern.compile(string);
                if (string2.trim().length() > 0) {
                    if (pattern.matcher(string2).matches()) {
                        this.m_PassFail.setText(PASS);
                    } else {
                        this.m_PassFail.setText(FAIL);
                    }
                }
            }
            this.m_RegExpSyntaxCheck.setText(SYNTAX_PREFIX + "Ok");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.m_RegExpSyntaxCheck.setText(SYNTAX_PREFIX + patternSyntaxException.getMessage());
            this.m_PassFail.setText(FAIL);
        }
    }

    private class RegExpDL
    implements DocumentListener {
        private RegExpDL() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            RegExpPanel.this.updateTest();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            RegExpPanel.this.updateTest();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            RegExpPanel.this.updateTest();
        }
    }

    private class CatalogChoiceListener
    implements ItemListener {
        private CatalogChoiceListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!RegExpPanel.this.m_InUpdate) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                String string2 = RegExpCatalog.getStandardRegExps().get(string);
                if (string2 != null) {
                    RegExpPanel.this.m_RegExpText.setText(string2);
                }
            }
        }
    }
}

