/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.jdbc;

import com.elixirtech.jdom.Element;
import com.elixirtech.ui.IRenderable;
import com.elixirtech.ui.Icons;
import java.awt.Color;
import javax.swing.Icon;

public class JDBCDriver
implements IRenderable,
Comparable<JDBCDriver> {
    public final String name;
    public final String cls;
    public final String url;
    private boolean m_Exists;
    static final Icon RED = Icons.getColourIcon(Color.RED);
    static final Icon GREEN = Icons.getColourIcon(Color.GREEN);

    public JDBCDriver(boolean bl, Element element) {
        this.name = element.getAttributeValue("name");
        this.cls = element.getAttributeValue("class");
        this.url = element.getAttributeValue("url");
        if (bl) {
            this.m_Exists = true;
        } else {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class.forName(this.cls, false, classLoader);
                this.m_Exists = true;
            }
            catch (Throwable throwable) {
                this.m_Exists = false;
            }
        }
    }

    public boolean exists() {
        return this.m_Exists;
    }

    @Override
    public int compareTo(JDBCDriver jDBCDriver) {
        if (this.m_Exists && !jDBCDriver.m_Exists) {
            return -1;
        }
        if (jDBCDriver.m_Exists && !this.m_Exists) {
            return 1;
        }
        return this.name.compareTo(jDBCDriver.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        if (this.m_Exists) {
            return GREEN;
        }
        return RED;
    }

    public String toString() {
        return this.name;
    }
}

