/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.attributes;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.attributes.ui.DataAttributesDialog;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.attributes.AttributesNode;
import com.elixirtech.data2.datasource.processor.attributes.AttributesSchemaPanel;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;

public class AttributesPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    private AttributesSchemaPanel m_SchemaPanel;

    public AttributesPage() {
        super("Attributes", null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "AttributesPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_SchemaPanel = new AttributesSchemaPanel(iWizard.isReadOnly(), false);
        this.m_SchemaPanel.getTable().addMouseListener(new ML());
        this.m_Component.add("schema", this.m_SchemaPanel);
        this.positionComponents();
        DataSchema dataSchema = ((ProcessorWizard)this.m_Wizard).getInputSchema();
        ProcessorNode processorNode = ((ProcessorWizard)iWizard).getProcessorNode();
        if (dataSchema != null) {
            DataSchema dataSchema2 = processorNode instanceof AttributesNode ? ((AttributesNode)processorNode).getSchema(dataSchema) : dataSchema;
            this.m_SchemaPanel.setSchema(dataSchema2, new HashSet<String>());
        }
        I18N.ENSEMBLE_MAP.injectComponents("AttributesPage.", this.m_Component);
    }

    private void positionComponents() {
        this.stickTop("schema");
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        AttributesNode attributesNode = new AttributesNode();
        int n = this.m_SchemaPanel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ResultSchemaPanel.SchemaColumn schemaColumn = this.m_SchemaPanel.getColumn(i);
            attributesNode.putAttributes(schemaColumn.name, schemaColumn.attrs);
        }
        ((ProcessorWizard)this.m_Wizard).setProcessorNode((ProcessorNode)attributesNode);
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = AttributesPage.this.m_SchemaPanel.getSelection()) >= 0) {
                ResultSchemaPanel.SchemaColumn schemaColumn = AttributesPage.this.m_SchemaPanel.getColumn(n);
                ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
                DataAttributesDialog dataAttributesDialog = new DataAttributesDialog(elixirFrame.getFrame(), schemaColumn.attrs, AttributesPage.this.m_Wizard.isReadOnly());
                dataAttributesDialog.setLocationRelativeTo(AttributesPage.this.m_Component);
                elixirFrame.showModal(dataAttributesDialog);
                if (dataAttributesDialog.isOk()) {
                    schemaColumn.attrs = dataAttributesDialog.getDataAttributes();
                    AbstractTableModel abstractTableModel = (AbstractTableModel)AttributesPage.this.m_SchemaPanel.getTable().getModel();
                    abstractTableModel.fireTableRowsUpdated(n, n);
                }
            }
        }
    }
}

