/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.debug;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.debug.DebugNode;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.JTextField;

public class DebugPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    private JTextField m_Name;
    private JTextField m_Inspect;

    public DebugPage() {
        super("Debug", null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DebugPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Name = SwingFactory.newTextField("name");
        this.m_Inspect = SwingFactory.newTextField("inspect");
        this.m_Component.add(SwingFactory.newLabel("name-label"));
        this.m_Component.add(this.m_Name);
        this.m_Component.add(SwingFactory.newLabel("inspect-label"));
        this.m_Component.add(this.m_Inspect);
        this.positionComponents();
        ProcessorNode processorNode = ((ProcessorWizard)iWizard).getProcessorNode();
        if (processorNode instanceof DebugNode) {
            DebugNode debugNode = (DebugNode)processorNode;
            this.m_Name.setText(debugNode.getName());
            this.m_Inspect.setText(debugNode.getInspectionString());
        }
        I18N.ENSEMBLE_MAP.injectComponents("DebugPage.", this.m_Component);
    }

    private void positionComponents() {
        this.stickTop("name");
        this.stickRight("name");
        this.stickLeft("name-label");
        this.vCenter("name-label", "name");
        this.putRight("name", "name-label,inspect-label", 10);
        this.stickLeft("inspect-label");
        this.vCenter("inspect-label", "inspect");
        this.alignBelow("inspect", "name", 5);
        this.stickRight("inspect");
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        DebugNode debugNode = new DebugNode(this.m_Name.getText(), this.m_Inspect.getText());
        ((ProcessorWizard)this.m_Wizard).setProcessorNode((ProcessorNode)debugNode);
    }
}

