/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.invert;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.invert.InvertDataPage;
import com.elixirtech.data2.datasource.processor.invert.InvertDataProcessor2;
import com.elixirtech.data2.datasource.processor.invertdata.InvertDataNode;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;

public class InferSchemaPage
extends RelativeLayoutWizardPage
implements ActionListener {
    public static final String NAME = "InvertData.InferSchema";
    private DataSchema m_Schema;
    private ResultSchemaPanel m_Panel;

    public InferSchemaPage() {
        super(NAME, null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "InvertDataSchemaPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ProcessorWizard processorWizard = (ProcessorWizard)iWizard;
        JButton jButton = SwingFactory.newButton("infer");
        jButton.setText(I18N.ENSEMBLE.getString("InvertDataSchemaPage.INFER_SCHEMA"));
        jButton.addActionListener(this);
        jButton.setEnabled(processorWizard.getInputSchema() != null);
        ProcessorNode processorNode = processorWizard.getProcessorNode();
        if (processorNode instanceof InvertDataNode) {
            InvertDataNode invertDataNode = (InvertDataNode)processorNode;
            this.m_Schema = invertDataNode.getSchema();
        }
        this.m_Component.add(jButton);
        this.m_Panel = new ResultSchemaPanel(true);
        this.m_Panel.setSchema(this.m_Schema, new HashSet<String>());
        this.m_Component.add(this.m_Panel);
        this.stickTop("infer");
        this.hCenter("infer");
        this.putBelow("schema", "infer", 5);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        InvertDataNode invertDataNode = ((InvertDataPage)this.m_Wizard.getPage("InvertData")).getNode();
        this.m_Schema = InvertDataProcessor2.inferSchema(processorWizard, invertDataNode, this.m_Schema);
        this.m_Panel.setSchema(this.m_Schema, new HashSet<String>());
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public void doFinish() {
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        InvertDataNode invertDataNode = (InvertDataNode)processorWizard.getProcessorNode();
        invertDataNode.setSchema(this.m_Schema);
    }
}

