/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.invert;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.invert.InferSchemaPage;
import com.elixirtech.data2.datasource.processor.invert.InvertTableModel;
import com.elixirtech.data2.datasource.processor.invertdata.InvertDataNode;
import com.elixirtech.ensemble.EnsembleAction;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;

public class InvertDataPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    public static final String NAME = "InvertData";
    private JComboBox m_Column;
    private JTextField m_FieldName;
    private JTable m_Fields;
    private JButton m_SelectAll;
    private JButton m_DeselectAll;

    public InvertDataPage() {
        super(NAME, "InvertData.InferSchema");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "InvertDataPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        this.m_Component.add(SwingFactory.newLabel("col-label"));
        this.m_Column = SwingFactory.newComboBox("col", this.getFieldList());
        this.m_Component.add(this.m_Column);
        this.m_Component.add(SwingFactory.newLabel("fieldname-label"));
        this.m_FieldName = SwingFactory.newTextField("fieldname");
        this.m_Component.add(this.m_FieldName);
        this.m_SelectAll = SwingFactory.newButton("sel", new SelectAllAction());
        this.m_SelectAll.setMargin(new Insets(0, 0, 0, 0));
        this.m_Component.add(this.m_SelectAll);
        this.m_DeselectAll = SwingFactory.newButton("desel", new DeselectAllAction());
        this.m_DeselectAll.setMargin(new Insets(0, 0, 0, 0));
        this.m_Component.add(this.m_DeselectAll);
        InvertTableModel invertTableModel = new InvertTableModel(processorWizard);
        this.m_Fields = SwingFactory.newTable("fields-table");
        this.m_Fields.setModel(invertTableModel);
        this.m_Component.add(SwingFactory.newScrollPane("fields", this.m_Fields));
        ProcessorNode processorNode = processorWizard.getProcessorNode();
        if (processorNode instanceof InvertDataNode) {
            InvertDataNode invertDataNode = (InvertDataNode)processorNode;
            this.m_Column.setSelectedItem(invertDataNode.getInvertColumn());
            this.m_FieldName.setText(invertDataNode.getFieldName());
            invertTableModel.setKeep(invertDataNode.getFields());
        }
        this.stickLeft("col-label");
        this.stickTop("col");
        this.vCenter("col-label", "col");
        this.putRight("col", "col-label,fieldname-label", 5);
        this.stickRight("col");
        this.alignBelow("fieldname", "col", 3);
        this.stickLeft("fieldname-label");
        this.vCenter("fieldname-label", "fieldname");
        this.stickRight("desel");
        this.putLeft("sel", "desel");
        this.putLeft("fieldname", "sel");
        this.setHeight("sel", "fieldname");
        this.setHeight("desel", "fieldname");
        this.putBelow("sel", "col", 3);
        this.putBelow("desel", "col", 3);
        this.putBelow("fields", "fieldname", 3);
        this.stickLeft("fields");
        this.stickRight("fields");
        this.stickBottom("fields");
        I18N.ENSEMBLE_MAP.injectComponents("InvertDataPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    public String getInvertColumn() {
        return (String)this.m_Column.getSelectedItem();
    }

    public String getFieldName() {
        return this.m_FieldName.getText();
    }

    public String[] getFields() {
        InvertTableModel invertTableModel = (InvertTableModel)this.m_Fields.getModel();
        return invertTableModel.getKeep();
    }

    @Override
    public void doFinish() {
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        processorWizard.setProcessorNode((ProcessorNode)this.getNode());
        ((InferSchemaPage)this.m_Wizard.getPage("InvertData.InferSchema")).doFinish();
    }

    public InvertDataNode getNode() {
        return new InvertDataNode(this.getInvertColumn(), this.getFieldName(), this.getFields());
    }

    private String[] getFieldList() {
        DataSchema dataSchema = ((ProcessorWizard)this.m_Wizard).getInputSchema();
        if (dataSchema != null) {
            String[] stringArray = new String[dataSchema.getColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = dataSchema.getColumnName(i);
            }
            return stringArray;
        }
        return new String[0];
    }

    private class SelectAllAction
    extends EnsembleAction {
        public SelectAllAction() {
            super("InvertData.SelectAll");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InvertTableModel invertTableModel = (InvertTableModel)InvertDataPage.this.m_Fields.getModel();
            invertTableModel.selectAll();
        }
    }

    private class DeselectAllAction
    extends EnsembleAction {
        public DeselectAllAction() {
            super("InvertData.DeselectAll");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InvertTableModel invertTableModel = (InvertTableModel)InvertDataPage.this.m_Fields.getModel();
            invertTableModel.deselectAll();
        }
    }
}

