/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.invert;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.invertdata.InvertDataNode;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.mozilla.javascript.Scriptable;

public class InvertDataProcessor2
extends BasicProcessor {
    private InvertDataNode m_Node;
    private DataSchema m_Schema;

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast((Object)this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_Owner);
        }
        return null;
    }

    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (InvertDataNode)processorNode;
        this.m_Schema = this.m_Node.getSchema();
    }

    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    public String getName() {
        return "Invert Data";
    }

    public String getType() {
        return "InvertData";
    }

    public String getDescription() {
        return null;
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void loadFrom(Element element) throws IOException {
        String[] stringArray2;
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        Element element2 = element.getChild("invert-data", Data2Constants.NS_DATASOURCE);
        String string2 = element2.getAttributeValue("invert-column");
        String string3 = element2.getAttributeValue("field-name");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray2 : element2.getChildren("field", Data2Constants.NS_DATASOURCE)) {
            String string4 = stringArray2.getAttributeValue("name");
            if (!StringUtil.notEmpty(string4)) continue;
            arrayList.add(string4);
        }
        stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        this.m_Node = new InvertDataNode(string2, string3, stringArray2);
        this.m_Schema = this.readSchema(element2);
        this.m_Node.setSchema(this.m_Schema);
    }

    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
        Element element2 = new Element("invert-data", Data2Constants.NS_DATASOURCE);
        if (this.m_Node != null) {
            element2.setAttribute("invert-column", this.attr(this.m_Node.getInvertColumn()));
            element2.setAttribute("field-name", this.attr(this.m_Node.getFieldName()));
            String[] stringArray = this.m_Node.getFields();
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = new Element("field", Data2Constants.NS_DATASOURCE);
                element3.setAttribute("name", this.attr(stringArray[i]));
                element2.addContent((Content)element3);
            }
        }
        if (this.m_Schema != null) {
            this.writeSchema(element2, this.m_Schema);
        }
        element.addContent((Content)element2);
    }

    private String attr(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private DataSchema readSchema(Element element) {
        Element element2 = element.getChild("schema", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            return DataSourceDefinition.loadSchema((Element)element2);
        }
        return null;
    }

    private void writeSchema(Element element, DataSchema dataSchema) {
        DataSourceDefinition.saveSchema((DataSchema)dataSchema, (Element)element);
    }

    public void pushTo(PushContext pushContext, DataListener dataListener) throws RuntimeException {
        if (this.m_Node != null) {
            DataTable dataTable = DataTable.build((PushContext)pushContext, (IDataSource)this.m_Parent, (IDataSource)this.m_Owner);
            DataSchema dataSchema = dataTable.getSchema();
            int n = dataSchema.getColumnIndex(this.m_Node.getInvertColumn());
            if (n >= 0) {
                Object[] objectArray;
                int n2;
                DataType dataType = dataSchema.getColumnType(n);
                String string = this.m_Node.getFieldName();
                String[] stringArray = this.m_Node.getFields();
                int[] nArray = new int[stringArray.length];
                DataType[] dataTypeArray = new DataType[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    nArray[i] = dataSchema.getColumnIndex(stringArray[i]);
                    if (nArray[i] < 0) continue;
                    dataTypeArray[i] = dataSchema.getColumnType(nArray[i]);
                }
                DataType dataType2 = InvertDataProcessor2.getMatchingType(dataTypeArray);
                SchemaBuilder schemaBuilder = new SchemaBuilder(true);
                int n3 = 0;
                if (StringUtil.notEmpty(string)) {
                    schemaBuilder.add(string, DataType.STRING, new DataAttributes());
                    ++n3;
                }
                DataRecord[] dataRecordArray = dataTable.getRecords();
                for (n2 = 0; n2 < dataRecordArray.length; ++n2) {
                    objectArray = dataSchema.format(dataType, dataRecordArray[n2].getData(n));
                    if (schemaBuilder.contains((String)objectArray)) {
                        throw new RuntimeException("InvertData: Duplicate column name: " + (String)objectArray + " in " + this.m_Node.getInvertColumn());
                    }
                    schemaBuilder.add((String)objectArray, dataType2, new DataAttributes());
                }
                this.m_Schema = schemaBuilder.getSchema();
                dataListener.startData((IDataSource)this);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    objectArray = new Object[this.m_Schema.getColumnCount()];
                    if (n3 > 0) {
                        objectArray[0] = stringArray[n2];
                    }
                    int n4 = 0;
                    while (n4 + n3 < objectArray.length) {
                        if (nArray[n2] >= 0) {
                            objectArray[n4 + n3] = dataRecordArray[n4].getData(nArray[n2]);
                        }
                        ++n4;
                    }
                    DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray);
                    boolean bl = dataListener.processRecord(dataRecord);
                    if (!bl) break;
                }
                dataListener.endData((IDataSource)this);
            }
        } else {
            dataListener.startData((IDataSource)this);
            dataListener.endData((IDataSource)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataSchema inferSchema(ProcessorWizard processorWizard, InvertDataNode invertDataNode, DataSchema dataSchema) {
        DSPanel dSPanel;
        IDataSource iDataSource;
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        IPanelView iPanelView = iViewModel.getCurrentView();
        if (iPanelView instanceof DSPanel && (iDataSource = (dSPanel = (DSPanel)iViewModel.getCurrentView()).getDataSource(processorWizard.getInput())) != null) {
            Object object;
            HashMap<String, String> hashMap = null;
            List list = iDataSource.getParameters();
            if (list.size() > 0) {
                object = new ParameterUI(list, null);
                elixirFrame.showWizard((IWizard)object);
                if (!((Wizard)object).isFinished()) {
                    return dataSchema;
                }
                hashMap = new HashMap<String, String>();
                ((ParameterUI)object).populateProperties(hashMap);
            }
            object = new DefaultPushContext();
            if (hashMap != null) {
                object.setParameters(hashMap);
            }
            JavaScriptEngine javaScriptEngine = null;
            try {
                CompositeDataSource compositeDataSource = (CompositeDataSource)MutableDataSource.unwrap(dSPanel.getDataSource());
                javaScriptEngine = JavaScriptEngine.getInstance();
                javaScriptEngine.pushScope((Scriptable)new CompositeScope(compositeDataSource));
                String string = compositeDataSource.getJavaScript();
                if (StringUtil.notEmpty(string)) {
                    try {
                        javaScriptEngine.execute("Composite Script", string);
                    }
                    catch (Throwable throwable) {
                        ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("CachePage.COMPOSITE_SCRIPT_ERROR"), throwable);
                    }
                }
                DataTable dataTable = DataTable.build((PushContext)object, (IDataSource)iDataSource);
                DataSchema dataSchema2 = InvertDataProcessor2.invertSchema(dataTable, invertDataNode);
                return dataSchema2;
            }
            catch (RuntimeException runtimeException) {
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18N.ENSEMBLE.getString("Error.CANT_INFER_SCHEMA"), (Throwable)runtimeException);
            }
            finally {
                if (javaScriptEngine != null) {
                    javaScriptEngine.popScope();
                    JavaScriptEngine.disposeInstance();
                }
            }
        }
        return null;
    }

    private static DataSchema invertSchema(DataTable dataTable, InvertDataNode invertDataNode) {
        DataSchema dataSchema;
        int n;
        String string = invertDataNode.getInvertColumn();
        String string2 = invertDataNode.getFieldName();
        String[] stringArray = invertDataNode.getFields();
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        if (StringUtil.notEmpty(string2)) {
            schemaBuilder.add(string2, DataType.STRING, new DataAttributes());
        }
        if (stringArray.length > 0 && (n = (dataSchema = dataTable.getSchema()).getColumnIndex(string)) >= 0) {
            Object object;
            DataType dataType = dataSchema.getColumnType(n);
            DataType[] dataTypeArray = new DataType[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = dataSchema.getColumnIndex(stringArray[i]);
                if (n2 < 0) continue;
                dataTypeArray[i] = dataSchema.getColumnType(n2);
            }
            DataType dataType2 = InvertDataProcessor2.getMatchingType(dataTypeArray);
            DataRecord[] dataRecordArray = dataTable.getRecords();
            TreeSet<Object> treeSet = new TreeSet<Object>();
            for (int i = 0; i < dataRecordArray.length; ++i) {
                object = dataSchema.format(dataType, dataRecordArray[i].getData(n));
                if (schemaBuilder.contains((String)object)) {
                    treeSet.add(object);
                    continue;
                }
                schemaBuilder.add((String)object, dataType2, new DataAttributes());
            }
            if (treeSet.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer("Duplicate columns found: ");
                object = treeSet.iterator();
                while (object.hasNext()) {
                    stringBuffer.append((String)object.next());
                    if (!object.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                ((IErrorHandler)Elixir.get(IErrorHandler.class)).userError(stringBuffer.toString());
            }
        }
        return schemaBuilder.getSchema();
    }

    private static DataType getMatchingType(DataType[] dataTypeArray) {
        DataType dataType = InvertDataProcessor2.allSame(dataTypeArray);
        if (dataType != null) {
            return dataType;
        }
        dataType = InvertDataProcessor2.allNumeric(dataTypeArray);
        if (dataType != null) {
            return dataType;
        }
        dataType = InvertDataProcessor2.allDate(dataTypeArray);
        if (dataType != null) {
            return dataType;
        }
        return DataType.STRING;
    }

    private static DataType allSame(DataType[] dataTypeArray) {
        DataType dataType = dataTypeArray[0];
        if (dataType == null) {
            return null;
        }
        for (int i = 1; i < dataTypeArray.length; ++i) {
            if (dataTypeArray[i] == null) {
                return null;
            }
            if (dataType.getTypeId() == dataTypeArray[i].getTypeId()) continue;
            return null;
        }
        return dataType;
    }

    private static DataType allNumeric(DataType[] dataTypeArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (dataTypeArray[i] == null) {
                return null;
            }
            if (!dataTypeArray[i].isNumeric()) {
                return null;
            }
            int n = dataTypeArray[i].getTypeId();
            if (n == 6) {
                bl = true;
                continue;
            }
            if (n != 18) continue;
            bl2 = true;
        }
        if (bl2) {
            return DataType.DECIMAL;
        }
        if (bl) {
            return DataType.DOUBLE;
        }
        return DataType.LONG;
    }

    private static DataType allDate(DataType[] dataTypeArray) {
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (dataTypeArray[i] == null) {
                return null;
            }
            int n = dataTypeArray[i].getTypeId();
            if (n == 4 || n == 12 || n == 13) continue;
            return null;
        }
        return DataType.TIMESTAMP;
    }
}

