/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.javascript;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.javascript.JSSchemaPage;
import com.elixirtech.data2.datasource.processor.javascript.JavaScriptNode;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class JSScriptsPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    public static final String PAGE_NAME = "JS.Scripts";
    private JEditor m_StartData;
    private JEditor m_StartGroup;
    private JEditor m_ProcessRecord;
    private JEditor m_EndGroup;
    private JEditor m_EndData;

    public JSScriptsPage() {
        super(PAGE_NAME, "JS.Schema");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "JSScriptsPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        JTabbedPane jTabbedPane = SwingFactory.newTabbedPane("tabs");
        ProcessorNode processorNode = ((ProcessorWizard)this.m_Wizard).getProcessorNode();
        if (!(processorNode instanceof JavaScriptNode)) {
            processorNode = new JavaScriptNode();
        }
        JavaScriptNode javaScriptNode = (JavaScriptNode)processorNode;
        this.m_StartData = this.buildScript(javaScriptNode.getStartData());
        this.m_StartGroup = this.buildScript(javaScriptNode.getStartGroup());
        this.m_ProcessRecord = this.buildScript(javaScriptNode.getProcessRecord());
        this.m_EndGroup = this.buildScript(javaScriptNode.getEndGroup());
        this.m_EndData = this.buildScript(javaScriptNode.getEndData());
        jTabbedPane.addTab(this.tabName("startData"), new JScrollPane(this.m_StartData));
        jTabbedPane.addTab(this.tabName("startGroup"), new JScrollPane(this.m_StartGroup));
        jTabbedPane.addTab(this.tabName("processRecord"), new JScrollPane(this.m_ProcessRecord));
        jTabbedPane.addTab(this.tabName("endGroup"), new JScrollPane(this.m_EndGroup));
        jTabbedPane.addTab(this.tabName("endData"), new JScrollPane(this.m_EndData));
        this.m_StartData.setToolTipText(I18N.ENSEMBLE.getString("JSScriptsPage.HELP_START_DATA"));
        this.m_StartGroup.setToolTipText(I18N.ENSEMBLE.getString("JSScriptsPage.HELP_START_GROUP"));
        this.m_ProcessRecord.setToolTipText(I18N.ENSEMBLE.getString("JSScriptsPage.HELP_PROCESS_RECORD"));
        this.m_EndGroup.setToolTipText(I18N.ENSEMBLE.getString("JSScriptsPage.HELP_END_GROUP"));
        this.m_EndData.setToolTipText(I18N.ENSEMBLE.getString("JSScriptsPage.HELP_END_DATA"));
        this.m_Component.add(jTabbedPane);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickTop("tabs");
        this.stickBottom("tabs");
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    private JEditor buildScript(String string) {
        REJavaScriptTypes.Kit kit = new REJavaScriptTypes.Kit();
        JEditor jEditor = new JEditor(string, kit);
        return jEditor;
    }

    @Override
    public void doFinish() {
        ProcessorNode processorNode = ((ProcessorWizard)this.m_Wizard).getProcessorNode();
        if (!(processorNode instanceof JavaScriptNode)) {
            processorNode = new JavaScriptNode();
            ((ProcessorWizard)this.m_Wizard).setProcessorNode(processorNode);
        }
        JavaScriptNode javaScriptNode = (JavaScriptNode)processorNode;
        javaScriptNode.setStartData(this.m_StartData.getText());
        javaScriptNode.setStartGroup(this.m_StartGroup.getText());
        javaScriptNode.setProcessRecord(this.m_ProcessRecord.getText());
        javaScriptNode.setEndGroup(this.m_EndGroup.getText());
        javaScriptNode.setEndData(this.m_EndData.getText());
        JSSchemaPage jSSchemaPage = (JSSchemaPage)this.m_Wizard.getPage("JS.Schema");
        jSSchemaPage.doFinish();
    }

    private String tabName(String string) {
        return I18N.ENSEMBLE.getString("DataListener." + string);
    }
}

