/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.map;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.map.MapFieldNode;
import com.elixirtech.data2.datasource.processor.map.MapFieldPage;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;

public class InferSchemaPage
extends RelativeLayoutWizardPage
implements ActionListener {
    public static final String NAME = "MapInferSchema";
    private DataSchema m_ReferenceSchema;
    private DataSchema m_SourceDataSchema;
    private DataSchema m_Schema;
    private ResultSchemaPanel m_Panel;

    public InferSchemaPage() {
        super(NAME, null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "MapFieldSchemaPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ProcessorWizard processorWizard = (ProcessorWizard)iWizard;
        JButton jButton = SwingFactory.newButton("infer");
        jButton.setText(I18N.ENSEMBLE.getString("MapFieldSchemaPage.INFER_SCHEMA"));
        jButton.addActionListener(this);
        this.m_SourceDataSchema = processorWizard.getInputSchema();
        jButton.setEnabled(this.m_SourceDataSchema != null);
        ProcessorNode processorNode = processorWizard.getProcessorNode();
        if (processorNode instanceof MapFieldNode) {
            MapFieldNode mapFieldNode = (MapFieldNode)processorNode;
            this.m_Schema = mapFieldNode.getSchema();
        }
        this.m_Component.add(jButton);
        this.m_Panel = new ResultSchemaPanel(true);
        this.m_Panel.setSchema(this.m_Schema, new HashSet<String>());
        this.m_Component.add(this.m_Panel);
        this.stickTop("infer");
        this.hCenter("infer");
        this.putBelow("schema", "infer", 5);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
        this.m_Panel.setAllowClearSelection(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        MapFieldPage mapFieldPage = (MapFieldPage)this.m_Wizard.getPage("MapField");
        mapFieldPage.doFinishPage();
        MapFieldNode mapFieldNode = mapFieldPage.getNode();
        this.m_Schema = MapFieldNode.inferSchema((MapFieldNode)mapFieldNode, (DataSchema)this.m_SourceDataSchema, (DataSchema)this.m_ReferenceSchema);
        this.m_Panel.setSchema(this.m_Schema, new HashSet<String>());
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public void doFinish() {
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        MapFieldNode mapFieldNode = (MapFieldNode)processorWizard.getProcessorNode();
        this.m_Schema = MapFieldNode.inferSchema((MapFieldNode)mapFieldNode, (DataSchema)this.m_SourceDataSchema, (DataSchema)this.m_ReferenceSchema);
        this.m_Panel.setSchema(this.m_Schema, new HashSet<String>());
        mapFieldNode.setSchema(this.m_Schema);
    }

    public void setReferenceSchema(DataSchema dataSchema) {
        this.m_ReferenceSchema = dataSchema;
    }
}

