/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.map;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.SpringUtilities;
import com.elixirtech.ui.SwingFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class MapFieldDialog
extends JDialog
implements ActionListener {
    private String[] m_Result;
    private Vector<String> m_SourceValues = new Vector();
    private Vector<String> m_TargetValues = new Vector();
    private List<String[]> m_ListOfMapFields;
    private DataSchema m_SourceDS;
    private DataSchema m_TargetDS;
    private JComboBox m_Source;
    private JComboBox m_Target;
    private JButton m_OK;
    private JButton m_Cancel;

    public MapFieldDialog(JFrame jFrame, List<String[]> list, DataSchema dataSchema, DataSchema dataSchema2, String[] stringArray, List<String[]> list2) {
        super((Frame)jFrame, I18N.ENSEMBLE.getString("MapFieldDialog.TITLE"));
        this.m_ListOfMapFields = list;
        this.setDefaultCloseOperation(2);
        this.m_OK = SwingFactory.newOkButton(this);
        this.m_Cancel = SwingFactory.newCancelButton(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.m_OK);
        jPanel.add(this.m_Cancel);
        Bundle.ARCH_MAP.injectComponents("MapFieldDialog.", jPanel);
        this.add("South", jPanel);
        this.addCombos(dataSchema, dataSchema2, stringArray, list2);
        this.pack();
    }

    public void addCombos(DataSchema dataSchema, DataSchema dataSchema2, String[] stringArray, List<String[]> list) {
        Object object2;
        this.m_SourceDS = dataSchema;
        this.m_TargetDS = dataSchema2;
        int n = this.m_SourceDS.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.m_SourceValues.add(this.m_SourceDS.getColumnName(i));
        }
        if (stringArray != null) {
            for (Object object2 : this.m_ListOfMapFields) {
                if (object2[0].equals(stringArray[0])) continue;
                this.m_SourceValues.remove(object2[0]);
            }
        }
        if (list != null) {
            for (Object object2 : this.m_ListOfMapFields) {
                this.m_SourceValues.remove(object2[0]);
            }
        }
        this.m_Source = new JComboBox<String>(this.m_SourceValues);
        this.m_Target = new JComboBox<String>(this.m_TargetValues);
        if (stringArray != null) {
            this.m_Source.setSelectedItem(stringArray[0]);
        }
        JLabel jLabel = new JLabel(I18N.ENSEMBLE.getString("MapFieldDialog.MAP_FIELD"));
        object2 = new JLabel(I18N.ENSEMBLE.getString("MapFieldDialog.SOURCE"));
        JLabel jLabel2 = new JLabel(I18N.ENSEMBLE.getString("MapFieldDialog.TARGET"));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel.add(jLabel);
        jPanel2.add((Component)object2);
        jPanel2.add(this.m_Source);
        jPanel2.add(jLabel2);
        jPanel2.add(this.m_Target);
        SpringUtilities.makeCompactGrid(jPanel2, 2, 2, 5, 5, 5, 5);
        this.add("North", jPanel);
        this.add("Center", jPanel2);
        this.updateCombo();
        if (stringArray != null) {
            this.m_Target.addItem(stringArray[1]);
            this.m_Target.setSelectedItem(stringArray[1]);
        }
    }

    public void updateCombo() {
        String string = (String)this.m_Source.getSelectedItem();
        if (string == null) {
            return;
        }
        this.m_Target.removeAllItems();
        int n = this.m_TargetDS.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.m_Target.addItem(this.m_TargetDS.getColumnName(i));
        }
        for (String[] stringArray : this.m_ListOfMapFields) {
            this.m_Target.removeItem(stringArray[1]);
        }
        if (this.m_Target.getItemCount() == 0) {
            this.m_OK.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_OK) {
            Object object = this.m_Source.getSelectedItem();
            Object object2 = this.m_Target.getSelectedItem();
            if (object != null && object2 != null) {
                this.m_Result = new String[]{(String)object, (String)object2};
            }
        }
        this.dispose();
    }

    public String[] getResult() {
        return this.m_Result;
    }
}

