/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.map;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.map.InferSchemaPage;
import com.elixirtech.data2.datasource.processor.map.MapFieldDialog;
import com.elixirtech.data2.datasource.processor.map.MapFieldNode;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.EditableTable;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MapFieldPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    public static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MapFieldPage.class);
    public static final String[] MAPFIELDS = new String[]{"MapFieldPage.SOURCE", "MapFieldPage.MAP"};
    public static final String NAME = "MapField";
    private Map<String, String> m_Maps = new HashMap<String, String>();
    private ArrayList<String[]> m_List = new ArrayList();
    private MapFieldTableModel m_Model;
    private DataSchema m_SourceDataSchema;
    private String m_ReferenceDataSource;
    private DataSchema m_RefDataSchema;
    private MapFieldNode m_Node;
    private JButton m_Select;
    private JTextField m_DS;
    private Color m_DSForground;
    private MapFieldTable m_MapTable;

    public MapFieldPage() {
        super(NAME, "MapInferSchema");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "MapFieldPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        this.m_DS = SwingFactory.newTextField("refds");
        this.m_DSForground = this.m_DS.getForeground();
        this.m_Select = SwingFactory.newDotsButton();
        this.m_Select.setName("refds-select");
        this.m_Select.addActionListener(new SelectDataSourceAL());
        JLabel jLabel = SwingFactory.newLabel("refds-lbl");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("West", jLabel);
        jPanel.add("Center", this.m_DS);
        jPanel.add("East", this.m_Select);
        jPanel.setName("ref");
        this.m_Component.add(jPanel);
        this.m_Model = new MapFieldTableModel();
        this.m_MapTable = new MapFieldTable(this.m_Model);
        JScrollPane jScrollPane = new JScrollPane(this.m_MapTable, 20, 31);
        jScrollPane.setName("model");
        this.m_Component.add(jScrollPane);
        this.m_SourceDataSchema = processorWizard.getInputSchema();
        ProcessorNode processorNode = ((ProcessorWizard)iWizard).getProcessorNode();
        if (processorNode instanceof MapFieldNode) {
            this.m_Node = (MapFieldNode)processorNode;
            this.m_ReferenceDataSource = this.m_Node.getReferenceDataSource();
            this.m_Maps = this.m_Node.getMap();
            if (this.m_ReferenceDataSource != null) {
                this.m_DS.setText(this.m_ReferenceDataSource);
                this.refreshReference();
            }
            this.update();
        }
        this.positionComponents();
        this.m_MapTable.setEnableAdd(!StringUtil.isEmpty(this.m_DS.getText()));
        this.m_DS.getDocument().addDocumentListener(new DocumentWatch());
        I18N.ENSEMBLE_MAP.injectComponents("MapFieldPage.", this.m_Component);
    }

    @Override
    public void setVisible(boolean bl) {
        InferSchemaPage inferSchemaPage = (InferSchemaPage)this.m_Wizard.getPage("MapInferSchema");
        inferSchemaPage.setReferenceSchema(this.m_RefDataSchema);
    }

    private void positionComponents() {
        this.stickTop("ref");
        this.stickLeft("ref");
        this.stickRight("ref");
        this.putBelow("model", "ref", 5);
        this.stickLeft("model");
        this.stickRight("model");
        this.stickBottom("model");
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public void doFinishPage() {
        InferSchemaPage inferSchemaPage = (InferSchemaPage)this.m_Wizard.getPage("MapInferSchema");
        inferSchemaPage.setReferenceSchema(this.m_RefDataSchema);
        this.m_Node = new MapFieldNode();
        this.m_Maps.clear();
        for (String[] stringArray : this.m_List) {
            this.m_Maps.put(stringArray[0], stringArray[1]);
        }
        this.m_Node.setMap(this.m_Maps);
        this.m_Node.setReferenceDataSource(this.m_ReferenceDataSource);
        ((ProcessorWizard)this.m_Wizard).setProcessorNode((ProcessorNode)this.m_Node);
    }

    @Override
    public void doFinish() {
        this.doFinishPage();
        ((InferSchemaPage)this.m_Wizard.getPage("MapInferSchema")).doFinish();
    }

    public void update() {
        if (this.m_Maps == null) {
            return;
        }
        Set<String> set = this.m_Maps.keySet();
        this.m_List.clear();
        for (String string : set) {
            this.m_List.add(new String[]{string, this.m_Maps.get(string)});
        }
        this.m_Model.fireTableDataChanged();
    }

    protected MapFieldNode getNode() {
        this.doFinish();
        return this.m_Node;
    }

    public void refreshReference() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        IDataSource iDataSource = null;
        try {
            iDataSource = dataSourceManager.getDataSource(null, this.m_ReferenceDataSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iDataSource == null) {
            this.m_RefDataSchema = null;
            this.m_MapTable.setEnableAdd(false);
            this.m_DS.setForeground(Color.RED);
        } else {
            this.m_RefDataSchema = iDataSource.getSchema();
            this.m_MapTable.setEnableAdd(true);
            this.m_DS.setForeground(this.m_DSForground);
        }
    }

    class SelectDataSourceAL
    implements ActionListener {
        SelectDataSourceAL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
            FileType fileType = (FileType)repositoryExplorer.getFileType("text/x-datasource").get();
            RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), I18N.ENSEMBLE.getString("MapFieldPage.SELECTION_DATASOURCE"), fileType);
            repositoryChooser.setCanSelectFolders(false);
            repositoryChooser.setLocationRelativeTo(MapFieldPage.this.m_Select);
            elixirFrame.showModal(repositoryChooser);
            if (repositoryChooser.isOk()) {
                FileObject fileObject = repositoryChooser.getSelection();
                MapFieldPage.this.m_ReferenceDataSource = fileObject.getPathString();
                MapFieldPage.this.m_DS.setText(MapFieldPage.this.m_ReferenceDataSource);
                DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                try {
                    IDataSource iDataSource = dataSourceManager.getDataSource(null, MapFieldPage.this.m_ReferenceDataSource);
                    MapFieldPage.this.m_RefDataSchema = iDataSource.getSchema();
                }
                catch (RuntimeException runtimeException) {
                    m_Log.warn((Object)("Unable to locate: " + MapFieldPage.this.m_ReferenceDataSource));
                }
            }
        }
    }

    public class MapFieldTable
    extends EditableTable {
        public MapFieldTable(MapFieldTableModel mapFieldTableModel) {
            super(mapFieldTableModel, true, false);
            this.setAutoResizeMode(4);
            this.addActionListener(this);
        }

        public void setEnableAdd(boolean bl) {
            this.m_Plus.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            String string = actionEvent.getActionCommand();
            int n = -1;
            if ("minus".equals(string)) {
                int n2;
                objectArray = this.m_Table.getSelectedRows();
                Arrays.sort(objectArray);
                for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                    MapFieldPage.this.m_List.remove(objectArray[n2]);
                }
                n2 = objectArray[0] - 1;
                if (n2 >= 0 && n2 < MapFieldPage.this.m_Model.getRowCount()) {
                    n = n2;
                } else {
                    MapFieldPage.this.m_Model.fireTableDataChanged();
                    return;
                }
            }
            if ("plus".equals(string)) {
                objectArray = this.showMapFieldEditor(null, MapFieldPage.this.m_List);
                if (objectArray != null) {
                    MapFieldPage.this.m_List.add((String[])objectArray);
                    n = MapFieldPage.this.m_Model.getRowCount() - 1;
                }
            } else if ("edit".equals(string) && (objectArray = (Object[])this.showMapFieldEditor(MapFieldPage.this.m_List.get(n = this.m_Table.getSelectedRow()), null)) != null) {
                MapFieldPage.this.m_List.set(n, (String[])objectArray);
            }
            MapFieldPage.this.m_Model.fireTableDataChanged();
            this.m_Table.getSelectionModel().setSelectionInterval(n, n);
        }

        public String[] showMapFieldEditor(String[] stringArray, List<String[]> list) {
            MapFieldPage.this.refreshReference();
            if (MapFieldPage.this.m_SourceDataSchema == null || MapFieldPage.this.m_RefDataSchema == null) {
                return null;
            }
            if (list != null && list.size() == MapFieldPage.this.m_SourceDataSchema.getColumnCount()) {
                JOptionPane.showMessageDialog(this.m_Table, I18N.ENSEMBLE.getString("MapFieldPage.ALL_FIELDMAPPED"), I18N.ENSEMBLE.getString("MapFieldPage.title"), 1);
                return null;
            }
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            MapFieldDialog mapFieldDialog = new MapFieldDialog(elixirFrame.getFrame(), MapFieldPage.this.m_List, MapFieldPage.this.m_SourceDataSchema, MapFieldPage.this.m_RefDataSchema, stringArray, list);
            mapFieldDialog.setLocationRelativeTo(this.getTable());
            elixirFrame.showModal(mapFieldDialog);
            return mapFieldDialog.getResult();
        }
    }

    public class MapFieldTableModel
    extends ElxTableModel {
        MapFieldTableModel() {
            super(I18N.ENSEMBLE, MAPFIELDS);
        }

        @Override
        public int getRowCount() {
            return MapFieldPage.this.m_List.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String[] stringArray = MapFieldPage.this.m_List.get(n);
            return stringArray[n2];
        }
    }

    class DocumentWatch
    implements DocumentListener {
        DocumentWatch() {
        }

        private void update() {
            MapFieldPage.this.m_ReferenceDataSource = MapFieldPage.this.m_DS.getText();
            MapFieldPage.this.refreshReference();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }
    }
}

