/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.remdup;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.wizard.datastore.TypePage;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import java.util.Set;

public class DataStoreTypePage
extends RelativeLayoutWizardPage {
    public static final String NAME = "DataStoreType";
    private I18NComboBox m_OutputTypes;
    private ResultSchemaPanel m_SchemaPanel;

    public DataStoreTypePage() {
        super(NAME, "<dynamic>");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "RemDupDataStoreTypePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        ProcessorNode processorNode = processorWizard.getProcessorNode();
        String[] stringArray = DataStoreRegistry.getNames();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "DataStore.Type." + stringArray[i].replace(' ', '_');
        }
        Name[] nameArray = I18NComboBox.buildModel(stringArray, I18N.ENSEMBLE, stringArray2);
        this.m_OutputTypes = I18NComboBox.apply(nameArray);
        this.m_OutputTypes.setName("list");
        if (processorNode != null) {
            this.m_OutputTypes.setSelectedId(processorNode.getUserProperty("DataStore_Type"));
        } else {
            this.m_OutputTypes.setSelectedId("None");
        }
        this.m_OutputTypes.addItemListener(new FieldWatcher(this.m_Wizard));
        this.m_SchemaPanel = new ResultSchemaPanel();
        DataSchema dataSchema = processorWizard.getInputSchema();
        if (dataSchema != null && processorNode != null) {
            Set set = GOUtil.getDiscardSet((Node)processorNode, (String)"DataStore_Discard");
            this.m_SchemaPanel.setSchema(dataSchema, set);
        }
        this.m_Component.add(SwingFactory.newLabel("list-label"));
        this.m_Component.add(this.m_OutputTypes);
        this.m_Component.add(this.m_SchemaPanel);
        this.stickLeft("list-label");
        this.vCenter("list-label", "list");
        this.stickTop("list");
        this.putRight("list", "list-label", 10);
        this.stickRight("list");
        this.putBelow("schema", "list", 5);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
        I18N.ENSEMBLE_MAP.injectComponents("RemDupDataStoreTypePage.", this.m_Component);
    }

    public void performFinish() {
        ProcessorWizard processorWizard = (ProcessorWizard)this.m_Wizard;
        ProcessorNode processorNode = processorWizard.getProcessorNode();
        processorNode.setUserProperty("DataStore_Type", this.m_OutputTypes.getSelectedId());
        GOUtil.setDiscardSet((Node)processorNode, (String)"DataStore_Discard", this.m_SchemaPanel.getDiscardSet());
        TypePage typePage = (TypePage)this.getNextPage();
        if (typePage != null) {
            typePage.performFinish();
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    @Override
    public IWizardPage getNextPage() {
        return this.m_Wizard.getPage(this.m_OutputTypes.getSelectedId());
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }
}

