/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.remdup;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTypeHelper;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.table.ElxTableModel;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

class DuplicateTableModel
extends ElxTableModel {
    private static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Type", "TableModel.Test"};
    private DataSchema m_Schema;
    private Set<String> m_Test = new TreeSet<String>();

    public DuplicateTableModel(ProcessorWizard processorWizard) {
        super(I18N.ENSEMBLE, COLUMNS);
        this.m_Schema = processorWizard.getInputSchema();
    }

    @Override
    public int getRowCount() {
        return this.m_Schema != null ? this.m_Schema.getColumnCount() : 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 2) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.m_Schema.getColumnName(n);
        }
        if (n2 == 1) {
            return DataTypeHelper.getI18NName(this.m_Schema.getColumnType(n));
        }
        return this.m_Test.contains(this.m_Schema.getColumnName(n)) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.m_Schema.getColumnName(n);
        if (Boolean.TRUE.equals(object)) {
            this.m_Test.add(string);
        } else {
            this.m_Test.remove(string);
        }
    }

    public void selectAll() {
        int n = this.m_Schema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.m_Test.add(this.m_Schema.getColumnName(i));
        }
        this.fireTableRowsUpdated(0, n - 1);
    }

    public void deselectAll() {
        this.m_Test.clear();
        int n = this.m_Schema.getColumnCount();
        this.fireTableRowsUpdated(0, n - 1);
    }

    public void setTests(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_Test.add(stringArray[i]);
        }
    }

    public String[] getTests() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.m_Schema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            hashSet.add(this.m_Schema.getColumnName(i));
        }
        this.m_Test.retainAll(hashSet);
        String[] stringArray = new String[this.m_Test.size()];
        this.m_Test.toArray(stringArray);
        return stringArray;
    }
}

