/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.remdup;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.remdup.DataStoreTypePage;
import com.elixirtech.data2.datasource.processor.remdup.DuplicateNode;
import com.elixirtech.data2.datasource.processor.remdup.DuplicateTableModel;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class RemoveDuplicatesPage
extends RelativeLayoutWizardPage
implements IFinishPage,
ActionListener {
    private JCheckBox m_InputSorted;
    private DuplicateTableModel m_Model;
    private JTable m_Table;

    public RemoveDuplicatesPage() {
        super("RemoveDuplicates", "DataStoreType");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "RemoveDuplicatesPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_InputSorted = SwingFactory.newCheckBox("sorted");
        JButton jButton = SwingFactory.newButton("selAll");
        jButton.setActionCommand("selAll");
        jButton.addActionListener(this);
        JButton jButton2 = SwingFactory.newButton("deselAll");
        jButton2.setActionCommand("deselAll");
        jButton2.addActionListener(this);
        this.m_Model = new DuplicateTableModel((ProcessorWizard)iWizard);
        this.m_Table = SwingFactory.newTable();
        this.m_Table.setModel(this.m_Model);
        this.m_Component.add(this.m_InputSorted);
        this.m_Component.add(jButton);
        this.m_Component.add(jButton2);
        this.m_Component.add(SwingFactory.newScrollPane("table", this.m_Table));
        this.positionComponents();
        ProcessorNode processorNode = ((ProcessorWizard)iWizard).getProcessorNode();
        if (processorNode instanceof DuplicateNode) {
            DuplicateNode duplicateNode = (DuplicateNode)processorNode;
            this.m_InputSorted.setSelected(duplicateNode.isInputSorted());
            this.m_Model.setTests(duplicateNode.getTests());
        }
        I18N.ENSEMBLE_MAP.injectComponents("RemoveDuplicatesPage.", this.m_Component);
    }

    private void positionComponents() {
        this.stickTop("sorted");
        this.stickLeft("sorted");
        this.stickTop("selAll");
        this.stickTop("deselAll");
        this.stickRight("deselAll");
        this.putLeft("selAll", "deselAll", -5);
        this.putBelow("table", "sorted,selAll,deselAll", 5);
        this.stickLeft("table");
        this.stickRight("table");
        this.stickBottom("table");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("selAll".equals(string)) {
            this.m_Model.selectAll();
        } else if ("deselAll".equals(string)) {
            this.m_Model.deselectAll();
        }
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        DuplicateNode duplicateNode = new DuplicateNode(this.m_InputSorted.isSelected(), this.m_Model.getTests());
        ((ProcessorWizard)this.m_Wizard).setProcessorNode((ProcessorNode)duplicateNode);
        DataStoreTypePage dataStoreTypePage = (DataStoreTypePage)this.m_Wizard.getPage("DataStoreType");
        dataStoreTypePage.performFinish();
    }
}

