/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.sql;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.sql.SQLNode;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.RESQLTypes;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.processor.ProcessorWizard;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.StyledEditorKit;

public class SQLScriptsPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    public static final String PAGE_NAME = "SQL.Scripts";
    private JEditor m_StartData;
    private JEditor m_StartGroup;
    private JEditor m_ProcessRecord;
    private JEditor m_EndGroup;
    private JEditor m_EndData;

    public SQLScriptsPage() {
        super(PAGE_NAME, null);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "SQLScriptsPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        JTabbedPane jTabbedPane = SwingFactory.newTabbedPane("tabs");
        ProcessorNode processorNode = ((ProcessorWizard)this.m_Wizard).getProcessorNode();
        if (!(processorNode instanceof SQLNode)) {
            processorNode = new SQLNode();
        }
        SQLNode sQLNode = (SQLNode)processorNode;
        this.m_StartData = this.buildScript(sQLNode.getStartData());
        this.m_StartGroup = this.buildScript(sQLNode.getStartGroup());
        this.m_ProcessRecord = this.buildScript(sQLNode.getProcessRecord());
        this.m_EndGroup = this.buildScript(sQLNode.getEndGroup());
        this.m_EndData = this.buildScript(sQLNode.getEndData());
        jTabbedPane.addTab(this.tabName("startData"), new JScrollPane(this.m_StartData));
        jTabbedPane.addTab(this.tabName("startGroup"), new JScrollPane(this.m_StartGroup));
        jTabbedPane.addTab(this.tabName("processRecord"), new JScrollPane(this.m_ProcessRecord));
        jTabbedPane.addTab(this.tabName("endGroup"), new JScrollPane(this.m_EndGroup));
        jTabbedPane.addTab(this.tabName("endData"), new JScrollPane(this.m_EndData));
        this.m_Component.add(jTabbedPane);
        this.stickLeft("tabs");
        this.stickRight("tabs");
        this.stickTop("tabs");
        this.stickBottom("tabs");
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    private JEditor buildScript(String string) {
        StyledEditorKit styledEditorKit = RESQLTypes.kit();
        JEditor jEditor = new JEditor(string, styledEditorKit);
        return jEditor;
    }

    @Override
    public void doFinish() {
        SQLNode sQLNode = (SQLNode)((ProcessorWizard)this.m_Wizard).getProcessorNode();
        sQLNode.setStartData(this.m_StartData.getText());
        sQLNode.setStartGroup(this.m_StartGroup.getText());
        sQLNode.setProcessRecord(this.m_ProcessRecord.getText());
        sQLNode.setEndGroup(this.m_EndGroup.getText());
        sQLNode.setEndData(this.m_EndData.getText());
    }

    private String tabName(String string) {
        return I18N.ENSEMBLE.getString("DataListener." + string);
    }
}

